# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculates column mean and variance. Adapted from pagoda2.
#' https://github.com/kharchenkolab/pagoda2/blob/main/src/misc2.cpp
#'
#' @param sY sparse matrix Gene by cell matrix of counts
#' @param rowSel numeric The selected rows (genes)
#' @param ncores numeric The number of cores
#' 
#' @return data.frame with columns of mean, variance, and number of observeatios 
#' for each gene across samples
#' @export
#' 
#' @examples
#' library(Matrix)
#' donor_by_gene <- rbind(c(9,2,1,5), c(3,3,1,2))
#' donor_by_gene <- Matrix(donor_by_gene, sparse = TRUE)
#' result <- colMeanVars(donor_by_gene, rowSel = NULL, ncores=1)
colMeanVars <- function(sY, rowSel, ncores = 1L) {
    .Call('_scITD_colMeanVars', PACKAGE = 'scITD', sY, rowSel, ncores)
}

#' Calculates factor-stratified sums for each column. Adapted from pagoda2.
#' https://github.com/kharchenkolab/pagoda2/blob/main/src/misc2.cpp
#'
#' @param sY sparse matrix Gene by cell matrix of counts
#' @param rowSel factor The donor that each cell is from
#' 
#' @return matrix of summed counts per gene per sample
#' @export
get_sums <- function(sY, rowSel) {
    .Call('_scITD_get_sums', PACKAGE = 'scITD', sY, rowSel)
}

