genColorArrows <-
function(satin.obj, pass=c("mean", "ascending", "descending"), pal) 
{
  if ( class(satin.obj) != "satin" )
    stop ( "need object of class 'satin'" )
  if ( satin.obj$itype != "quikscat" )
    stop ( "need 'QuikSCAT' data")

  if ( missing(pass) )
    pass <- "mean"
     tp <- match.arg( pass )
     switch(tp,
           mean = k <- 3,
           ascending = k <- 1,
           descending = k <- 2)

  u <- satin.obj[[3]][ , , k]
  v <- satin.obj[[4]][ , , k]
  speed <- sqrt(u^2 + v^2) 
  speed.lims <- rbind(Min=min(speed, na.rm=TRUE), Max=max(speed, na.rm=TRUE))   
    colnames(speed.lims) <- "wind speed"

  vecspeed <- as.vector(speed)
    col.arrows <- vecspeed
    vecspeed[is.na(vecspeed)] <- 999

  if ( !is.list(pal) )
    stop("a list, as generated by genColorPal(), is expected")
    pal.pal <- pal[[1]]
    nbcols <- length(pal.pal)
    pal.breaks <- pal[[2]]
    
   for (i in 1:length(col.arrows)) {
       for(j in 1:nbcols) {
         if( vecspeed[i] > pal.breaks[j] & vecspeed[i] <= pal.breaks[j+1] ) 
           col.arrows[i] <- pal.pal[j]
        }    
    }     
  result <- list(speed=speed, col.arrows=col.arrows, pal=pal.pal, 
                  breaks=pal.breaks, speed.lims=speed.lims)
  result
}

