% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSP.R
\name{simSP}
\alias{simSP}
\title{Similarity measure between snow profile pairs}
\usage{
simSP(
  ref,
  qw,
  gtype_distMat = sim2dist(grainSimilarity_evaluate(triag = FALSE)),
  verbose = FALSE,
  returnDF = FALSE
)
}
\arguments{
\item{ref}{snowprofile object 1}

\item{qw}{snowprofile object 2 (matched layers need to be on the same height grid of ref)}

\item{gtype_distMat}{a distance matrix that stores \strong{distance} information of grain types (\emph{Be careful} to convert
similarities, as in \link{grainSimilarity_evaluate}, into dissimilarities with \link{sim2dist}.)}

\item{verbose}{print similarities of different grain classes to console? default FALSE}

\item{returnDF}{additionally return the similarities of the grain classes as data.frame (analogously to verbose);
the return object then has the fields \verb{$sim} and \verb{$simDF}}
}
\value{
Either a scalar similarity between \verb{[0, 1]} with 1 referring to the two profiles being identical, or
(if \code{returnDF} is TRUE) a list with the elements \verb{$sim} and \verb{$simDF}.
}
\description{
A simple similarity score --based on avalanche hazard relevant characteristics-- is calculated for two snow profiles
that have been aligned onto the same height grid (either through DTW or resampling).
If one profile contains more layers than the other one, the layers with a non-matched height
represent missing layers and will be treated accordingly. The similarity score is weighted according to grain type
classes to accredit the importance of weak layers, new snow and crusts against less important bulk layers.
The similarity measure is compatible with top-down alignments and is symmetric with respect to its inputs, i.e.
\code{simSP(P1, P2) == simSP(P2, P1)}.
}
\details{
The grain classes contain the following grain types:
\itemize{
\item weak layers (wl): SH and DH
\item new snow (pp): PP and DF
\item crusts (cr): MFcr and IF
\item bulk: the rest (i.e., predominantly RG, FC, FCxr --- MF falls also in here, will maybe be adjusted in future.)
}
}
\examples{

## first align two profiles
alignment <- dtwSP(SPpairs$A_modeled, SPpairs$A_manual)

## then assess the similarity of the aligned profiles
SIM <- simSP(alignment$queryWarped, alignment$reference, verbose = TRUE)

}
