% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABSClass.R
\name{CoreABS}
\alias{CoreABS}
\title{CoreABS Object}
\description{
This is the parent \link[R6:R6Class]{R6} class of the Auto-correlated Bayesian Sampler \insertCite{@ABS, @zhu2024AutocorrelatedBayesianSampler}{samplr}. It is a sequential sampling model assuming people draw autocorrelated samples from memory or beliefs, i.e., posterior of hypotheses.
}
\references{
\insertAllCited{}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_chains}}{an integer of the number of chains for the sampler.}

\item{\code{nd_time}}{a numeric value of the non-decision time (in seconds).}

\item{\code{s_nd_time}}{a numeric value of the inter-trial-variability of the non-decision time (in seconds).}

\item{\code{distr_name}}{a character string indicating the type of the posterior hypothesis distribution.}

\item{\code{distr_params}}{a numeric vector of the additional parameters for the posterior hypothesis distribution.}

\item{\code{custom_distr}}{a list of functions that define the posterior hypothesis distribution.}

\item{\code{custom_start}}{a numeric value of the starting point if "custom_distr" is provided.}

\item{\code{sim_results}}{a data frame for saving the simulation results.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CoreABS-new}{\code{CoreABS$new()}}
\item \href{#method-CoreABS-clone}{\code{CoreABS$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoreABS-new"></a>}}
\if{latex}{\out{\hypertarget{method-CoreABS-new}{}}}
\subsection{Method \code{new()}}{
Create a new 'CoreABS' object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoreABS$new(
  n_chains,
  nd_time,
  s_nd_time,
  distr_name = NULL,
  distr_params = NULL,
  custom_distr = NULL,
  custom_start = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_chains}}{an integer of the number of chains for the sampler.}

\item{\code{nd_time}}{a numeric value of the non-decision time (in seconds).}

\item{\code{s_nd_time}}{a numeric value of the inter-trial-variability of the non-decision time (in seconds).}

\item{\code{distr_name}}{a character string indicating the type of the posterior hypothesis distribution. The package currently only supports \code{norm}, which represents normal distribution.}

\item{\code{distr_params}}{a numeric vector of the additional parameters for the posterior hypothesis distribution.}

\item{\code{custom_distr}}{a list of functions that define the posterior hypothesis distribution.}

\item{\code{custom_start}}{a numeric value of the starting point if "custom_distr" is provided.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new 'CoreABS' object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoreABS-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CoreABS-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoreABS$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
