% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sim}
\alias{sim}
\alias{sim.sim_setup}
\title{Start simulation}
\usage{
sim(x, ...)

\method{sim}{sim_setup}(x, ..., R = 1, parallel = FALSE, path = NULL)
}
\arguments{
\item{x}{a \code{sim_setup} or \code{data.frame}}

\item{...}{simulation components; If \code{parallel = TRUE} arguments passed to mclapply, see details.}

\item{R}{number of repetitions.}

\item{parallel}{if \code{FALSE} \code{lapply} is used; if \code{TRUE} a 'plug-and-play' version of mclapply is used; see details.}

\item{path}{optional path in which the simulation results can be saved.}
}
\value{
The return value is always a list. The elements are the resulting \code{data.frame}s of each simulation run.
}
\description{
This function can be applied to a \code{sim_setup}. It will start the simulation. Use the printing method as long as you are testing the scenario.
}
\details{
The backend for parallel computation is very experimental. You can find the code and documentation on www.github.com/wahani/parallelTools. In Windows parallelization is build around \code{\link[parallel]{clusterApply}}. If you are not using Windows the function \code{\link[parallel]{mclapply}} is used. See the parameters of \code{mclapply} how to control the parallelization. Parallizing trivial tasks in Windows will result in wasted time. Also working with large data.frames will be inefficient in Windows.
Use the \code{path} to store the simulation results to a directory. This may be a good idea for long running simulations and for those using large \code{data.frame}s. Use \code{\link{sim_read_data}}, to read load them again.
}
\examples{
setup <- sim_base_lm()
resultList <- sim(setup, R = 1)

# Will return a data frame
dat <- sim(sim_base() \%>\% sim_gen_x() \%>\% sim_gen_e())
}

