% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rv.R
\name{as.double.rv}
\alias{as.double.rv}
\title{Coercing Random Vectors to Real-valued}
\usage{
\method{as.double}{rv}(x, ...)
}
\arguments{
\item{x}{an rv object}

\item{\dots}{other arguments}
}
\description{
Coerces random vector objects into double-valued ones.
}
\details{
\code{as.double} coerces an rv object into double-valued one.  In effect,
the function \code{as.double} is applied to all simulations.
}
\examples{

  x <- as.logical(rvbern(prob=0.5)) 
  print(x)
  print(as.double(x))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
