% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysVarInOut.R
\name{sysVarOutResults}
\alias{sysVarOutResults}
\title{Produces results from sysVarOut.}
\usage{
sysVarOutResults(baseModel, testModel, Gaussian = TRUE)
}
\arguments{
\item{baseModel}{The name of the model that was produced by sysVarOut to be used as the null model for comparison (e.g., sysOut$models$base).}

\item{testModel}{The name of the model that was produced by sysVarOut that you want results for (e.g., sysOut$models$profile, sysOut$models$profilePlusDist, sysOut$models$profileByDist).}

\item{Gaussian}{Whether the system variable is Gaussian. Default is true.}
}
\value{
A list of results including an LRT comparison of the test model to the null, an omnibus anova test for the parameters in the model (this is identical to the LRT test for Gaussian dyadic system variables), a summary of the parameter estimates, and exponentiated parameter estimates (e.g., odds ratios) if Gaussian = FALSE.
}
\description{
Produces results from sysVarOut.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time", time_lag=2)
ic <- indivInertCoord(prepData=newData, whichModel="inertCoord")
profiles <- inspectProfiles(whichModel="inertCoord", prepData=newData, 
paramEst=ic$params, n_profiles=2)
fullData <- makeFullData(basedata=data, dyadId="couple", personId="person", 
dist_name="female", lpaData=profiles, params=ic$params)
sysOut <- sysVarOut(fullData=fullData, sysVar_name="conflict", sysVarType="indiv")
sysVarOutResults(baseModel=sysOut$models$base, testModel=sysOut$models$profileByDist)

}
