% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtiesShared.R
\name{makeCrossCorr}
\alias{makeCrossCorr}
\title{Calculates cross-correlations for a given variable and returns a dataframe with the largest absolute cross-correlation and its lag added for each dyad (e.g., it returns either the most negative or most positive cross-correlation, whichever is larger in absolute terms).}
\usage{
makeCrossCorr(basedata, dyadId, personId, obs_name, dist_name)
}
\arguments{
\item{basedata}{The original dataframe provided by the user that includes all variables needed for an rties analysis, including potential system and control variables, etc.}

\item{dyadId}{The name of the column in the dataframe that has the couple-level identifier.}

\item{personId}{The name of the column in the dataframe that has the person-level identifier.}

\item{obs_name}{The name of the column in the dataframe that has the time-varying observable (e.g., the variable for which dynamics will be assessed).}

\item{dist_name}{The name of the column in the dataframe that has a variable that distinguishes the partners (e.g., sex, mother/daughter, etc) that is numeric and scored 0/1.}
}
\value{
A cross-sectional version of the original dataframe with maximal absolute-value cross-correlations and their lags added for each dyad.
}
\description{
Calculates cross-correlations for a given variable and returns a dataframe with the largest absolute cross-correlation and its lag added for each dyad (e.g., it returns either the most negative or most positive cross-correlation, whichever is larger in absolute terms).
}
\examples{
data <- rties_ExampleDataShort
newData <- makeCrossCorr(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female")
head(newData)

}
