% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertCoord.R
\name{indivInertCoord}
\alias{indivInertCoord}
\title{Estimates versions of the inertia-coordination model for each dyad.}
\usage{
indivInertCoord(prepData, whichModel)
}
\arguments{
\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{whichModel}{Whether the model to be estimated is the inertia only model ("inert"), the coordination only model ("coord"), or the full inertia-coordination model ("inertCoord").}
}
\value{
The function returns a dataframe containing the parameter estimates, called "params", for use in the latent profile analysis.
}
\description{
The user specifies which of 3 models are to be estimated. Each model predicts the observed state variables (with linear trends removed) from either: 1) Inertia only ("inert")- each person's intercept and each person's own observed state variable lagged at the amount specified during the dataPrep step (again with linear trends removed), 2) Coordination only ("coord")- each person's intercept and each person's partner's state variable lagged at the amount specified (again with linear trends removed), or 3) Full inertia-coordination model ("inertCoord") - each person's intercept, each person's own observed state variable lagged at the amount specified during the dataPrep step (again with linear trends removed), and each person's partner's state variable lagged at the amount specified (again with linear trends removed).
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time", time_lag=2)
ic <- indivInertCoord(prepData=newData, whichModel="inertCoord")
head(ic$params)
}
