% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertCoord.R
\name{crossCorPlots}
\alias{crossCorPlots}
\title{Produces cross-correlation plots of the observed state variable for lags of -+ 20 time steps for each dyad.}
\usage{
crossCorPlots(basedata, personId, dyadId, obs_name, time_name)
}
\arguments{
\item{basedata}{A user provided dataframe.}

\item{personId}{The name of the column in the dataframe that has the person-level identifier.}

\item{dyadId}{The name of the column in the dataframe that has the dyad-level identifier.}

\item{obs_name}{The name of the column in the dataframe that has the time-varying observable (e.g., the variable for which dynamics will be assessed).}

\item{time_name}{The name of the column in the dataframe that indicates sequential temporal observations.}
}
\value{
Prints the plots to the screen.
}
\description{
Produces cross-correlation plots of the observed state variable for lags of -+ 20 time steps for each dyad.
}
\examples{
data <- rties_ExampleDataShort
crossCorPlots(basedata=data, dyadId="couple", personId="person", obs_name="dial", time_name="time")

}
