% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertCoord.R
\name{inertCoordResids}
\alias{inertCoordResids}
\title{Produces histograms of the residuals from the inertia-coordination model for each dyad.}
\usage{
inertCoordResids(prepData, whichModel, printPlots = T)
}
\arguments{
\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{whichModel}{Whether the model to be estimated is the inertia only model ("inert"), the coordination only model ("coord"), or the full inertia-coordination model ("inertCoord").}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
A list with the histograms of the residuals for each dyad.
}
\description{
Produces histograms of the residuals from the inertia-coordination model for each dyad.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time", time_lag=2)
temp <- newData[newData$dyad < 5, ]
residPlots <- inertCoordResids(prepData=temp, whichModel="inertCoord")

}
