% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{delete,character-method}
\alias{delete,SsimObject-method}
\title{Delete library, project, scenario, datasheet}
\usage{
delete(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)

\S4method{delete}{character}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)

\S4method{delete}{SsimObject}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Project/Scenario, or path to a library.}

\item{project}{character string, numeric, or vector of these. One or more project names or ids. Note that project argument is ignored if ssimObject is a list. Note that integer ids are slightly faster.}

\item{scenario}{character string, numeric, or vector of these. One or more scenario names or ids. Note that scenario argument is ignored if ssimObject is a list. Note that integer ids are slightly faster.}

\item{datasheet}{character string or vector of these. One or more datasheet names.}

\item{force}{logical. If FALSE (default), user will be prompted to approve removal of each item.}
}
\value{
This function returns invisibly a list of boolean values corresponding to each of the
input: `TRUE` upon success (i.e.successful deletion) and `FALSE` upon failure.
}
\description{
Deletes one or more items. Note that this is irreversible.
}
\examples{
\donttest{
temp_dir <- tempdir()
myses <- session()
myLibrary <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)

myProject <- project(myLibrary, project = "a project")
project(myLibrary)
delete(myLibrary, project = "a project", force = TRUE)
project(myLibrary)
}

}
