% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbiplot.R
\name{ggbiplot}
\alias{ggbiplot}
\title{Biplot for \code{rPCA} using ggplot2}
\usage{
ggbiplot(rpcaObj, pcs = c(1, 2), groups = NULL, ellipse = TRUE,
  alpha.ellipse = 0.2, loadings = TRUE, labels = TRUE, ...)
}
\arguments{
\item{rpcaObj}{object containing the \code{sdev} component, such as that returned
by \code{rpca}}

\item{pcs}{array_like \cr
an array with two values indicating which two PCs should be plotted,
by default the first two PCs are used, e.g., \eqn{c(1,2)}. \cr}

\item{groups}{optional, factor \cr
factor indicating groups}

\item{ellipse}{draw a 1sd data ellipse for each group}

\item{alpha.ellipse}{alpha transparency for ellipse}

\item{loadings}{draw arrows for the variables}

\item{labels}{label variables}

\item{...}{arguments passed to or from other methods, see \code{\link[ggplot2]{ggplot}}.}
}
\description{
Biplot for \code{rPCA} using ggplot2
}
\examples{
#See ?rpca
}
\author{
N. Benjamin Erichson, \email{nbe@st-andrews.ac.uk}
}
\seealso{
\code{\link{rpca}}, \code{\link[ggplot2]{ggplot}}
}

