% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_committees.R
\name{committees}
\alias{committees}
\alias{cg_committees}
\alias{cg_committee}
\alias{cg_committee_hearings}
\alias{cg_committee_comms}
\alias{cg_committees_comms_category}
\alias{cg_committees_comms_date}
\alias{cg_committees_comms_chamber}
\title{committees methods}
\usage{
cg_committees(congress, chamber, key = NULL, as = "table", ...)

cg_committee(congress, chamber, id, sub_id = NULL, key = NULL,
  as = "table", ...)

cg_committee_hearings(congress, chamber = NULL, id = NULL, key = NULL,
  as = "table", ...)

cg_committee_comms(congress, key = NULL, as = "table", ...)

cg_committees_comms_category(congress, category, key = NULL, as = "table",
  ...)

cg_committees_comms_date(date, key = NULL, as = "table", ...)

cg_committees_comms_chamber(congress, chamber, key = NULL, as = "table",
  ...)
}
\arguments{
\item{congress}{(character) The number of the Congress this update
took place during.}

\item{chamber}{(character) The chamber this update took place in. 'house'
or 'senate'.}

\item{key}{your ProPublica API key; pass in or loads from environment variable
stored as \code{PROPUBLICA_API_KEY} in either your .Renviron, or similar file
locatd in your home directory}

\item{as}{(character) IGNORED FOR NOW}

\item{...}{optional curl options passed on to \link[crul:HttpClient]{crul::HttpClient}.
See \code{\link[curl:curl_options]{curl::curl_options()}}}

\item{id}{(character) a commmitte id}

\item{sub_id}{(character) a sub-committee id}

\item{category}{(character) one of ec, pm, or pom}

\item{date}{(character) a date, of the form YYYY-MM-DD}
}
\value{
various things for now, since return objects vary quite a bit
among the different votes routes
}
\description{
committees methods
}
\examples{
\dontrun{
cg_committees(115, "senate")
cg_committee(115, "senate", "SSAF")
cg_committee(115, "senate", "HSAS", sub_id = "HSAS28")
cg_committee_hearings(115)
cg_committee_hearings(115, "house", "HSRU")
cg_committee_comms(115)
cg_committees_comms_category(115, "pm")
cg_committees_comms_date("2018-03-21")
cg_committees_comms_chamber(115, "house")
}
}
