% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_plot.R
\name{cor_plot}
\alias{cor_plot}
\title{Visualize Correlation Matrix Using Base Plot}
\usage{
cor_plot(cor.mat, method = "circle", type = "full", palette = NULL,
  p.mat = NULL, significant.level = 0.05, insignificant = c("cross",
  "blank"), label = FALSE, font.label = list())
}
\arguments{
\item{cor.mat}{the correlation matrix to visualize}

\item{method}{Character, the visualization method of correlation matrix to be
  used. Currently, it supports seven methods, named \code{"circle"}
  (default), \code{"square"}, \code{"ellipse"}, \code{"number"},
  \code{"pie"}, \code{"shade"} and \code{"color"}. See examples for details.

  The areas of circles or squares show the absolute value of corresponding
  correlation coefficients. Method \code{"pie"} and \code{"shade"} came from
  Michael Friendly's job (with some adjustment about the shade added on), and
  \code{"ellipse"} came from D.J. Murdoch and E.D. Chow's job, see in section
  References.}

\item{type}{Character, \code{"full"} (default), \code{"upper"} or
\code{"lower"}, display full matrix, lower triangular or upper triangular
matrix.}

\item{palette}{character vector containing the color palette.}

\item{p.mat}{matrix of p-value corresponding to the correlation matrix.}

\item{significant.level}{significant level, if the p-value is bigger than
\code{significant.level}, then the corresponding correlation coefficient is
regarded as insignificant.}

\item{insignificant}{character, specialized insignificant correlation
coefficients, "cross" (default), "blank". If "blank", wipe away the
corresponding glyphs; if "cross", add crosses (X) on corresponding glyphs.}

\item{label}{logical value. If TRUE, shows the correlation coefficient
labels.}

\item{font.label}{a list with one or more of the following elements: size
(e.g., 1), color (e.g., "black") and style (e.g., "bold"). Used to
customize the correlation coefficient labels. For example \code{font.label
= list(size = 1, color = "black", style = "bold")}.}

\item{...}{other arguments passed to \code{\link[corrplot]{corrplot}()}}
}
\description{
Provide a tibble-friendly framework to visualize a correlation
  matrix. Wrapper around the R base function
  \code{\link[corrplot]{corrplot}()}. Compared to
  \code{\link[corrplot]{corrplot}()}, it can handle directly the output of the
  functions \code{\link{cor_mat}() (in rstatix)}, \code{rcorr() (in Hmisc)},
  \code{correlate() (in corrr)} and \code{cor() (in stats)}.

  The p-values contained in the outputs of the functions
  \code{\link{cor_mat}()} and \code{rcorr()} are automatically detected and
  used in the visualization.
}
\examples{
# Compute correlation matrix
#::::::::::::::::::::::::::::::::::::::::::
cor.mat <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec) \%>\%
  cor_mat()

# Visualize correlation matrix
#::::::::::::::::::::::::::::::::::::::::::
# Full correlation matrix,
# insignificant correlations are marked by crosses
cor.mat \%>\% cor_plot()

# Reorder by correlation coefficient
# pull lower triangle and visualize
cor.lower.tri <- cor.mat \%>\%
  cor_reorder() \%>\%
  pull_lower_triangle()
cor.lower.tri \%>\% cor_plot()

# Change visualization methods
#::::::::::::::::::::::::::::::::::::::::::
cor.lower.tri \%>\%
  cor_plot(method = "pie")

cor.lower.tri \%>\%
  cor_plot(method = "color")

cor.lower.tri \%>\%
  cor_plot(method = "number")

# Show the correlation coefficient: label = TRUE
# Blank the insignificant correlation
#::::::::::::::::::::::::::::::::::::::::::
cor.lower.tri \%>\%
  cor_plot(
    method = "color",
    label = TRUE,
    insignificant = "blank"
  )

# Change the color palettes
#::::::::::::::::::::::::::::::::::::::::::

# Using custom color palette
# Require ggpubr: install.packages("ggpubr")
if(require("ggpubr")){
  my.palette <- get_palette(c("red", "white", "blue"), 200)
  cor.lower.tri \%>\%
   cor_plot(palette = my.palette)
}

# Using RcolorBrewer color palette
if(require("ggpubr")){
  my.palette <- get_palette("PuOr", 200)
  cor.lower.tri \%>\%
   cor_plot(palette = my.palette)
}

}
\seealso{
\code{\link{cor_as_symbols}()}
}
