% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_core_utilities.R
\name{rcmd}
\alias{rcmd}
\alias{getObjectRCode}
\title{Get Object R Code}
\usage{
rcmd(
  obj,
  ...,
  leadingArguments = NULL,
  includeDefaultParameters = FALSE,
  stringWrapParagraphWidth = 90,
  prefix = "",
  postfix = "",
  stringWrapPrefix = "",
  newArgumentValues = list()
)

getObjectRCode(
  obj,
  ...,
  leadingArguments = NULL,
  includeDefaultParameters = FALSE,
  stringWrapParagraphWidth = 90,
  prefix = "",
  postfix = "",
  stringWrapPrefix = "",
  newArgumentValues = list()
)
}
\arguments{
\item{obj}{The result object.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{leadingArguments}{A character vector with arguments that shall be inserted at the beginning of the function command, 
e.g., \code{design = x}. Be careful with this option because the created R command may no longer be valid if used.}

\item{includeDefaultParameters}{If \code{TRUE}, default parameters will be included in all \code{rpact} commands;
default is \code{FALSE}.}

\item{stringWrapParagraphWidth}{An integer value defining the number of characters after which a line break shall be inserted;
set to \code{NULL} to insert no line breaks.}

\item{prefix}{A character string that shall be added to the beginning of the R command.}

\item{postfix}{A character string that shall be added to the end of the R command.}

\item{stringWrapPrefix}{A prefix character string that shall be added to each new line, typically some spaces.}

\item{newArgumentValues}{A named list with arguments that shall be renewed in the R command, e.g., 
\code{newArgumentValues = list(informationRates = c(0.5, 1))}.}
}
\value{
A \code{\link[base]{character}} value or vector will be returned.
}
\description{
Returns the R source command of a result object.
}
\details{
\code{\link{getObjectRCode}} (short: \code{\link{rcmd}}) recreates 
the R commands that result in the specified object \code{obj}.  
\code{obj} must be an instance of class \code{ParameterSet}.
}
