% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studies.R
\name{studies_find_studies}
\alias{studies_find_studies}
\title{Find a Study}
\usage{
studies_find_studies(property = NULL, value = NULL, verbose = FALSE,
  exact = FALSE, detailed = TRUE, ...)
}
\arguments{
\item{property}{The property to be searched on (character)}

\item{value}{The property value to be searched on (character)}

\item{verbose}{Should the output include all metadata (logical
default \code{FALSE})}

\item{exact}{Should exact matching be used? (logical, default
\code{FALSE})}

\item{detailed}{If \code{TRUE} (default), the function will return
a data frame that summarizes information about the study (see
\sQuote{Value}). Otherwise, it only returns the study
identifiers.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
If \code{detailed=TRUE}, the function returns a data frame
    listing the study id (\code{study_ids}), the number of trees
    associated with this study (\code{n_trees}), the tree ids (at
    most 5) associated with the studies (\code{tree_ids}), the
    tree id that is a candidate for the synthetic tree if any
    (\code{candidate}), the year of publication of the study
    (\code{study_year}), the title of the publication for the
    study (\code{title}), and the DOI (Digital Object Identifier)
    for the study (\code{study_doi}).

    If \code{detailed=FALSE}, the function returns a data frame
    with a single column containing the study identifiers.
}
\description{
Return the identifiers of studies that match given properties
}
\examples{
\dontrun{
## To match a study for which the identifier is already known
one_study <- studies_find_studies(property="ot:studyId", value="pg_719")
list_trees(one_study)

## To find studies pertaining to Mammals
mammals <- studies_find_studies(property="ot:focalCladeOTTTaxonName",
                                value="mammalia")
## To extract the tree identifiers for each of the studies
list_trees(mammals)
## ... or for a given study
list_trees(mammals, "ot_308")

## Just the identifiers without other information about the studies
mammals <- studies_find_studies(property="ot:focalCladeOTTTaxonName",
                                value="mammalia", detailed=FALSE)
}
}
\seealso{
\code{\link{studies_properties}} which lists properties
    against which the studies can be
    searched. \code{\link{list_trees}} that returns a list for all
    tree ids associated with a study.
}
