% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lists.R
\name{create_osv_list}
\alias{create_osv_list}
\title{List packages identified in the OSV database}
\usage{
create_osv_list(
  rosv_query = NULL,
  ecosystem = NULL,
  delim = "\\t",
  as.data.frame = FALSE,
  refresh = FALSE,
  clear_cache = FALSE
)
}
\arguments{
\item{rosv_query}{A table of vulnerabilities (created via \code{query_osv()}); if not set, will pull an ecosystem's entire database.}

\item{ecosystem}{Character value of ecosystem name (e.g. PyPI or CRAN); should not be set if providing \code{rosv_query}.}

\item{delim}{The deliminator to separate the package and version details.}

\item{as.data.frame}{Boolean value to determine if a data.frame should be returned.}

\item{refresh}{Force refresh of the cache to grab latest details from OSV databases.}

\item{clear_cache}{Boolean value, to force clearing of the existing cache upon exiting function for downloaded JSON files.}
}
\value{
A vector object containing the package and version details; if \code{as.data.frame} is selected
this vector will be reformatted into a \code{data.frame()} object.
}
\description{
Create a list based upon package vulnerabilities discovered in the OSV database.
}
\details{
If used without assigning \code{rosv_query} parameter, all packages listed in the ecosystem
will be referenced. To speed up this creation process for large ecosystems you can set \code{future::plan()}
for parallelization; this will be respected via the \code{furrr} package. The default will be to run sequentially.

Please note, the default behaviour is to return all packages (and versions) associated with discovered vulnerabilities. Ensure you
have properly subset the returned query if not done so via the function parameters. Furthermore, if the package is
listed across several vulnerabilities, an additional deduplication step may need to be performed. Furthermore, the \code{clear_cache}
parameter is specific to a downloaded set of JSON files, it is not related to caching of specific API queries which happens
prior to using this step via functions like \code{query_osv()}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

pypi_vul <- create_osv_list(ecosystem = 'PyPI')
file_name1 <- file.path(tempdir(), 'pypi_vul.csv')
writeLines(pypi_vul, file_name1)

cran_vul <- create_osv_list(ecosystem = 'CRAN', delim = ',')
file_name2 <- file.path(tempdir(), 'cran_vul.csv')
writeLines(cran_vul, file_name2)

# Clean up
try(unlink(c(file_name1, file_name2)))

# Use from query instead of entire database
pkg_vul <- osv_query(c('dask', 'dash'), ecosystem = c('PyPI', 'PyPI'))
create_osv_list(rosv_query = pkg_vul)
\dontshow{\}) # examplesIf}
}
