% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{createWeights}
\alias{createWeights}
\title{Create control weights for matches dataset, and final data output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.}
\usage{
createWeights(matches, data, id)
}
\arguments{
\item{matches}{Dataframe containing the matches from comparison_pool}

\item{data}{The original data provided for the function.}

\item{id}{The individual id variable.}
}
\value{
A list containing two Dataframes. Matches - an updated dataset with
control weights added, and data_full an updated version of the original data
with weights added.
}
\description{
Create control weights for matches dataset, and final data output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.
}
\examples{
\dontrun{ 
id <- "indiv_id"
data(package="rollmatch", "rem_synthdata")
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                "tests/testthat/matches.rda")))
data <- rem_synthdata
matches <- addMatchesColumns(matches)
out_list <- createWeights(matches, data, id)
head(a)
}

}
\keyword{internal}
