% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMixedEffectDatasets.R
\name{prepareMixedEffectDataset}
\alias{prepareMixedEffectDataset}
\title{Prepare Dataset for Parametric Bootstrap}
\usage{
prepareMixedEffectDataset(
  formula,
  data,
  REML = TRUE,
  overrideBeta,
  overrideSigma,
  overrideTheta,
  ...
)
}
\arguments{
\item{formula}{passed on to \code{\link{lmer}}}

\item{data}{passed on to \code{\link{lmer}}}

\item{REML}{passed on to \code{\link{lmer}}}

\item{overrideBeta}{use to override beta used to simulate new datasets, by
default \code{\link{getME}}\code{(fm, "beta")} where \code{fm} is the
fitted model returned by \code{\link{lmer}}.}

\item{overrideSigma}{use to override sigma used to simulate new datasets, by
default \code{\link{getME}}\code{(fm, "sigma")} where \code{fm} is the
fitted model returned by \code{\link{lmer}}.}

\item{overrideTheta}{use to override theta used to simulate new datasets, by
default \code{\link{getME}}\code{(fm, "theta")} where \code{fm} is the
fitted model returned by \code{\link{lmer}}.}

\item{...}{all additional arguments are added to the returned list.}
}
\value{
List that can be passed to
  \code{\link{generateMixedEffectDatasets}}. \describe{ \item{\code{data}:
  }{the original dataset} \item{\code{X}: }{the X matrix as returned by
  \code{\link{getME}}} \item{\code{Z}: }{the Z matrix as returned by
  \code{\link{getME}}} \item{\code{Lambda}: }{the Lambda matrix as returned
  by \code{\link{getME}}} \item{\code{numberOfFixedEffects}: }{the number of
  fixed effects coefficients} \item{\code{numberOfRandomEffects}: }{the
  number of random effects} \item{\code{numberOfRows}: }{number of rows in
  the generated dataset} \item{\code{trueBeta}: }{true values used for beta}
  \item{\code{trueSigma}: }{true value used for sigma}
  \item{\code{trueTheta}: }{true values used for theta}
  \item{\code{formula}: }{formula to fit the model using \code{lmer}}
  \item{\code{...}: }{additional arguments passed via \code{...}} }
}
\description{
This function runs \code{\link{lmer}} and extracts all information needed to
generate new datasets using parametric bootstrap later.
}
\examples{
  preparedDataset <- prepareMixedEffectDataset(Reaction ~ Days + (Days|Subject), sleepstudy)
  str(preparedDataset)
}
\author{
Manuel Koller
}
