% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{mean.mfData}
\alias{mean.mfData}
\title{Cross-sectional mean of of a mfData object.}
\usage{
\method{mean}{mfData}(x, ...)
}
\arguments{
\item{x}{the multivariate functional dataset whose cross-sectional mean must
be computed, in form of \code{mfData} object.}

\item{...}{possible additional parameters. This argument is kept for
compatibility with the \code{S3} definition of \code{mean}, but it is not
actually used.}
}
\value{
The function returns a \code{mfData} object with one observation
defined on the same grid as the argument \code{x}'s representing the
desired cross-sectional mean.
}
\description{
This \code{S3} method implements the \bold{cross-sectional} mean of a
multivariate functional dataset stored in a \code{mfData} object, i.e. the
mean computed point-by-point along the grid over which the dataset is
defined.
}
\examples{

N = 1e2
L = 3
P = 1e2
grid = seq( 0, 1, length.out = P )

# Generating a gaussian functional sample with desired mean
target_mean = sin( 2 * pi * grid )
C = exp_cov_function( grid, alpha = 0.2, beta = 0.2 )
# Independent components
correlations = c( 0, 0, 0 )
mfD = mfData( grid,
              generate_gauss_mfdata( N, L,
                                     correlations = correlations,
                                     centerline = matrix( target_mean,
                                                          nrow = 3,
                                                          ncol = P,
                                                          byrow = TRUE ),
                                     listCov = list( C, C, C ) )
)

# Graphical representation of the mean
par( mfrow = c( 1, 3 ) )

for( iL in 1 : L )
{
  plot( mfD$fDList[[ 1 ]] )
  plot( mean( mfD )$fDList[[ 1 ]], col = 'black',
        lwd = 2, lty = 2, add = TRUE )
}
}
\seealso{
\code{\link{mfData}}
}

