% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsw.R
\name{bsw}
\alias{bsw}
\title{Blended sea winds (BSW)}
\usage{
bsw(date = NULL, uv_stress = "uv", resolution = "6hrly", ...)
}
\arguments{
\item{date}{(date/character) date, in the form YYYY-MM-DD if resolution
is 6hrly or daily, or in the form YYYY-MM if resolution is monthly.
For resolution=clm can be left NULL. If given, must be in the
range 1987-07-09 to today-1 (yesterday)}

\item{uv_stress}{(character) one of uv or stresss, not sure what these
mean exactly yet. Default: uv}

\item{resolution}{(character) temporal resolution. one of 6hrly,
clm, daily, or monthly. See Details.}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
an object of class \code{ncdf4}
}
\description{
The Blended Sea Winds dataset contains globally gridded, high-resolution
ocean surface vector winds and wind stresses on a global 0.25° grid, and
multiple time resolutions of six-hourly, daily, monthly, and 11-year
(1995–2005) climatological monthlies.
}
\details{
Products are available from July 9th, 1987 - present.

Uses \code{ncdf4} under the hood to read NetCDF files

Use \code{bsw_cache} object to manage cached files.
}
\note{
We only handle the netcdf files for now, we're avoiding the ieee
files, see http://www.cpc.ncep.noaa.gov/products/wesley/wgrib2/ieee.html
}
\section{Citing NOAA and BSW data}{

Message from NOAA: "We also ask you to acknowledge us in your use of the
data to help us justify continued service. This may be done by  including
text such as: The wind data are acquired from NOAA's National Climatic
Data Center, via their website
http://www.ncdc.noaa.gov/oa/rsad/blendedseawinds.html. We would also
appreciate receiving a copy of the relevant publication."
}

\section{Temporal resolution}{

\itemize{
\item 6hrly: 6-hourly, 4 global snapshots (u,v) at UTC 00, 06, 12 and 18Z
\item clm: climatological monthlies; also provided is the scalar
mean (u,v,w)
\item daily: averages of the 6hrly time points, thus with a center time
09Z; also provided is the scalar mean, (u,v,w)
\item monthly: averages of daily data; also provided is the scalar
mean (u,v,w)
}
}

\examples{
\dontrun{
# 6hrly data
## uv
x <- bsw(date = "2017-10-01")
## stress
y <- bsw(date = "2011-08-01", uv_stress = "stress")

# daily
z <- bsw(date = "2017-10-01", resolution = "daily")

# monthly
w <- bsw(date = "2011-08", resolution = "monthly")

# clm
# x <- bsw(resolution = "clm")
}
}
\references{
\url{https://www.ncdc.noaa.gov/data-access/marineocean-data/blended-global/blended-sea-winds}
ftp://eclipse.ncdc.noaa.gov/pub/seawinds/
ieee files: http://www.cpc.ncep.noaa.gov/products/wesley/wgrib2/ieee.html
}
