% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/storm_shp.R, R/storms.R, R/storms_meta.R
\name{storm_shp}
\alias{storm_data}
\alias{storm_meta}
\alias{storm_shp}
\alias{storm_shp_read}
\title{Get NOAA wind storm tabular data, metadata, or shp files from IBTrACS}
\usage{
storm_shp(basin = NULL, storm = NULL, year = NULL, type = "points",
  path = "~/.rnoaa/storms", overwrite = TRUE)

storm_shp_read(x)

storm_data(basin = NULL, storm = NULL, year = NULL,
  path = "~/.rnoaa/storms", overwrite = TRUE, ...)

storm_meta(what = "storm_columns")
}
\arguments{
\item{basin}{(character) A basin name, one of EP, NA, NI, SA, SI, SP, or WP.}

\item{storm}{(character) A storm serial number of the form YYYYJJJHTTNNN. See Details.}

\item{year}{(numeric) One of the years from 1842 to 2014}

\item{type}{(character) One of points or lines. This gives shp files with points, or with lines.}

\item{path}{(character) A path to store the files, Default: \code{~/.rnoaa/storms}}

\item{overwrite}{(logical) To overwrite the path to store files in or not, Default: TRUE.}

\item{x}{Output from \code{storm_shp}, a path to shp file to read in.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}

\item{what}{(character) One of storm_columns or storm_names.}
}
\description{
Get NOAA wind storm tabular data, metadata, or shp files from IBTrACS
}
\details{
International Best Track Archive for Climate Stewardship (IBTrACS)

Details for storm serial numbers:
\itemize{
 \item YYYY is the corresponding year of the first recorded observation of the storm
 \item JJJ is the day of year of the first recorded observation of the storm
 \item H is the hemisphere of the storm: N=Northern, S=Southern
 \item TT is the absolute value of the rounded latitude of the first recorded observation of the
 storm (range 0-90, if basin=SA or SH, then TT in reality is negative)
 \item NNN is the rounded longitude of the first recorded observation of the storm (range 0-359)
}

For example: \code{1970143N19091} is a storm in the North Atlantic which started on
May 23, 1970 near 19N 91E

See \url{http://www.ncdc.noaa.gov/ibtracs/index.php?name=numbering} for more.

The datasets included in the package \code{\link{storm_names}}, and
\code{\link{storm_columns}} may help in using these storm functions.
}
\examples{
\dontrun{
# Metadata
head( storm_meta() )
head( storm_meta("storm_columns") )
head( storm_meta("storm_names") )

# Tabular data
## Get tabular data for basins, storms, or years
storm_data(basin='WP')
storm_data(storm='1970143N19091')
storm_data(year=1940)
storm_data(year=1941)
storm_data(year=2010)

# shp files
## storm_shp downloads data and gives a path back
## to read in, use storm_shp_read
res <- storm_shp(basin='EP')
storm_shp_read(res)

## Get shp file for a storm
(res2 <- storm_shp(storm='1970143N19091'))

## Plot shp file data, we'll need sp library
library('sp')

### for year 1940, points
(res3 <- storm_shp(year=1940))
res3shp <- storm_shp_read(res3)
plot(res3shp)

### for year 1940, lines
(res3_lines <- storm_shp(year=1940, type="lines"))
res3_linesshp <- storm_shp_read(x=res3_lines)
plot(res3_linesshp)

### for year 2010, points
(res4 <- storm_shp(year=2010))
res4shp <- storm_shp_read(res4)
plot(res4shp)
}
}
\references{
\url{http://www.ncdc.noaa.gov/ibtracs/index.php?name=wmo-data}
}

