% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/buoy.R
\name{buoy}
\alias{buoy}
\alias{buoys}
\title{Get NOAA buoy data from the National Buoy Data Center}
\usage{
buoy(dataset, buoyid, year = NULL, datatype = NULL, ...)

buoys(dataset, ...)
}
\arguments{
\item{dataset}{(character) Dataset name to query. See below for Details. Required}

\item{buoyid}{(integer) Buoy ID. Required}

\item{year}{(integer) Year of data collection}

\item{datatype}{(character) Data type, one of 'c', 'cc', 'p', 'o'}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}
}
\description{
Get NOAA buoy data from the National Buoy Data Center
}
\details{
Functions:
\itemize{
 \item buoys Get available buoys given a dataset name
 \item buoy Get data given some combination of dataset name, buoy ID, year, and datatype
}

Options for the dataset parameter. One of:
\itemize{
 \item adcp - Acoustic Doppler Current Profiler data
 \item adcp2 - MMS Acoustic Doppler Current Profiler data
 \item cwind - Continuous Winds data
 \item dart - Deep-ocean Assessment and Reporting of Tsunamis data
 \item mmbcur - Marsh-McBirney Current Measurements data
 \item ocean - Oceanographic data
 \item pwind - Peak Winds data
 \item stdmet- Standard Meteorological data
 \item swden - Spectral Wave Density data with Spectral Wave Direction data
 \item wlevel - Water Level data
}
}
\examples{
\dontrun{
# Get available buoys
buoys(dataset = 'cwind')

# Get data for a buoy
## if no year or datatype specified, we get the first file
buoy(dataset = 'cwind', buoyid = 46085)

# Including specific year
buoy(dataset = 'cwind', buoyid = 41001, year = 1999)

# Including specific year and datatype
buoy(dataset = 'cwind', buoyid = 41001, year = 2008, datatype = "cc")
buoy(dataset = 'cwind', buoyid = 41001, year = 2008, datatype = "cc")

# Other datasets
buoy(dataset = 'ocean', buoyid = 42856)

# curl debugging
library('httr')
buoy(dataset = 'cwind', buoyid = 46085, config=verbose())
}
}
\references{
\url{http://www.ndbc.noaa.gov/} and \url{http://dods.ndbc.noaa.gov/}
}

