% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNGseq.R
\name{RNGseq}
\alias{RNGseq}
\alias{RNGseq_seed}
\title{Generate Sequence of Random Streams}
\usage{
RNGseq(n, seed = NULL, ..., simplify = TRUE, version = 2)

RNGseq_seed(seed = NULL, normal.kind = NULL, verbose = FALSE,
  version = 2)
}
\arguments{
\item{n}{Number of streams to be created}

\item{seed}{seed specification used to initialise the set of streams
using \code{\link{RNGseq_seed}}.}

\item{...}{extra arguments passed to \code{\link{RNGseq_seed}}.}

\item{simplify}{a logical that specifies if sequences of length 1 should be
unlisted and returned as a single vector.}

\item{version}{version of the function to use, to reproduce old behaviours.
Version 1 had a bug which made the generated stream sequences share most of their
seeds (!), as well as being not equivalent to calling \code{set.seed(seed); RNGseq_seed(NULL)}.
Version 2 fixes this bug.}

\item{normal.kind}{Type of Normal random generator. See \code{\link{RNG}}.}

\item{verbose}{logical to toggle verbose messages}
}
\value{
a list of integer vectors (or a single integer  vector if
\code{n=1} and \code{unlist=TRUE}).

a 7-length numeric vector.
}
\description{
These functions are used to generate independent streams of random numbers.
}
\section{Functions}{
\itemize{
\item \code{RNGseq}: Creates a given number of seeds for L'Ecuyer's RNG, that can be used to seed
parallel computation, making them fully reproducible.

This ensures complete reproducibility of the set of run.
The streams are created using L'Ecuyer's RNG, implemented in R core since
version 2.14.0 under the name \code{"L'Ecuyer-CMRG"} (see \code{\link{RNG}}).

Generating a sequence without specifying a seed uses a single draw of the
current RNG. The generation of a sequence using seed (a single or 6-length
numeric) a should not affect the current RNG state.

\item \code{RNGseq_seed}: generates the -- next -- random seed used as the first seed in
the sequence generated by \code{\link{RNGseq}}.
}}

\examples{
#--- RNGseq ---

RNGseq(3)
RNGseq(3)
RNGseq(3, seed=123)
# or identically
set.seed(123)
identical(RNGseq(3), RNGseq(3, seed=123))
\dontshow{
set.seed(123)
stopifnot( identical(RNGseq(3), RNGseq(3, seed=123)) ) 
}

RNGseq(3, seed=1:6, verbose=TRUE)
# select Normal kind
RNGseq(3, seed=123, normal.kind="Ahrens")


#--- RNGseq_seed ---

## generate a seed for RNGseq
# random  
RNGseq_seed() 
RNGseq_seed()
RNGseq_seed(NULL)
# fixed
RNGseq_seed(1)
RNGseq_seed(1:6)

# `RNGseq_seed(1)` is identical to 
set.seed(1)
s <- RNGseq_seed()
identical(s, RNGseq_seed(1))
\dontshow{ stopifnot(identical(s, RNGseq_seed(1))) }
 

}
\seealso{
\code{\link{RNGseq}}
}
