% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_mapshaper_commands}
\alias{apply_mapshaper_commands}
\title{Apply a mapshaper command string to a geojson object}
\usage{
apply_mapshaper_commands(data, command, force_FC, sys = FALSE)
}
\arguments{
\item{data}{geojson object or path to geojson file. If a file path, \code{sys}
must be true}

\item{command}{valid mapshaper command string}

\item{force_FC}{should the output be forced to be a FeatureCollection (or
Spatial*DataFrame) even if there are no attributes? Default \code{TRUE}.
FeatureCollections are more compatible with rgdal::readOGR and
geojsonio::geojson_sp. If FALSE and there are no attributes associated with
the geometries, a GeometryCollection (or Spatial object with no dataframe)
will be output.}

\item{sys}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}
}
\value{
geojson
}
\description{
Apply a mapshaper command string to a geojson object
}
