## ----, echo = FALSE, message = FALSE-------------------------------------
knitr::opts_chunk$set(comment="#",error=FALSE,tidy=FALSE)

## ------------------------------------------------------------------------
x <- list(p1 = list(type="A",score=c(c1=9)),
  p2 = list(type=c("A","B"),score=c(c1=8,c2=9)),
  p3 = list(type=c("B","C"),score=c(c1=9,c2=7)),
  p4 = list(type=c("B","C"),score=c(c1=8,c2=NA)))

## ------------------------------------------------------------------------
list.search(x, equal("A",exactly = TRUE))

## ------------------------------------------------------------------------
list.search(x, equal("A",exactly = TRUE), unlist = TRUE)

## ------------------------------------------------------------------------
list.search(x, equal(c("A","B"), exactly = TRUE))

## ------------------------------------------------------------------------
list.search(x, equal(c(9,7),exactly = TRUE))

## ------------------------------------------------------------------------
list.search(x, equal(9))

## ------------------------------------------------------------------------
list.search(x, all(equal(c(8,9))))

## ------------------------------------------------------------------------
list.search(x, all(equal(c(8,9)), na.rm = TRUE))

## ------------------------------------------------------------------------
list.search(x, equal("A"))

## ------------------------------------------------------------------------
list.search(x, equal(8))

## ------------------------------------------------------------------------
list.search(x, any(equal(c(8,9))))

## ------------------------------------------------------------------------
list.search(x, all(equal(c(8,9),include = TRUE)))

## ------------------------------------------------------------------------
list.search(x, any(equal(c(7,8,10),include = TRUE)))

## ------------------------------------------------------------------------
x <- list(
    p1 = list(name="Ken",age=24),
    p2 = list(name="Kent",age=26),
    p3 = list(name="Sam",age=24),
    p4 = list(name="Keynes",age=30),
    p5 = list(name="Kwen",age=31))

## ------------------------------------------------------------------------
equal("a","b",dist = 1)

## ------------------------------------------------------------------------
equal("a","hello",dist = 1)

## ------------------------------------------------------------------------
equal("a","hello",dist = 4, method = "dl")

## ------------------------------------------------------------------------
list.search(x, equal("ken", dist = 1), "character", unlist = TRUE)

## ------------------------------------------------------------------------
equal(12345,"1234",dist = 1)

## ------------------------------------------------------------------------
list.search(x, equal("ken", dist = 2), "character", unlist = TRUE)

## ------------------------------------------------------------------------
x <- list(
    p1 = list(name=c("Ken", "Ren"),age=24),
    p2 = list(name=c("Kent", "Potter"),age=26),
    p3 = list(name=c("Sam", "Lee"),age=24),
    p4 = list(name=c("Keynes", "Bond"),age=30),
    p5 = list(name=c("Kwen", "Hu"),age=31))

## ------------------------------------------------------------------------
list.search(x, any(equal("Ken", dist = 1)), "character")

## ------------------------------------------------------------------------
list.search(x, all(!equal("Ken", dist = 2)), "character")

## ------------------------------------------------------------------------
list.search(x, all(equal(c("Ken","Hu"), dist = 2)), "character")

## ------------------------------------------------------------------------
list.search(x, .[equal("Ken", dist = 1)], "character")

## ------------------------------------------------------------------------
x <- list(
    p1 = list(name=c("Ken", "Ren"),age=24),
    p2 = list(name=c("Kent", "Potter"),age=26),
    p3 = list(name=c("Sam", "Lee"),age=24),
    p4 = list(name=c("Keynes", "Bond"),age=30),
    p5 = list(name=c("Kwen", "Hu"),age=31))

## ------------------------------------------------------------------------
library(pipeR)
x %>>%
  list.filter(any(equal("Ken",name,dist = 1))) %>>%
  list.mapv(paste(name,collapse = " "))

