% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr.R
\name{expr_print}
\alias{expr_print}
\alias{expr_deparse}
\title{Print an expression}
\usage{
expr_print(x, width = peek_option("width"))

expr_deparse(x, width = peek_option("width"))
}
\arguments{
\item{x}{An object or expression to print.}

\item{width}{The width of the deparsed or printed expression.
Defaults to the global option \code{width}.}
}
\description{
\code{expr_print()}, powered by \code{expr_deparse()}, is an alternative
printer for R expressions with a few improvements over the base R
printer.
\itemize{
\item It colourises \link[=nse-defuse]{quosures} according to their environment.
Quosures from the global environment are printed normally while
quosures from local environments are printed in unique colour (or
in italic when all colours are taken).
\item It wraps inlined objects in angular brackets. For instance, an
integer vector unquoted in a function call (e.g.
\code{expr(foo(!!(1:3)))}) is printed like this: \code{foo(<int: 1L, 2L, 3L>)} while by default R prints the code to create that vector:
\code{foo(1:3)} which is ambiguous.
\item It respects the width boundary (from the global option \code{width})
in more cases.
}
}
\examples{
# It supports any object. Non-symbolic objects are always printed
# within angular brackets:
expr_print(1:3)
expr_print(function() NULL)

# Contrast this to how the code to create these objects is printed:
expr_print(quote(1:3))
expr_print(quote(function() NULL))

# The main cause of non-symbolic objects in expressions is
# quasiquotation:
expr_print(expr(foo(!!(1:3))))


# Quosures from the global environment are printed normally:
expr_print(quo(foo))
expr_print(quo(foo(!!quo(bar))))

# Quosures from local environments are colourised according to
# their environments (if you have crayon installed):
local_quo <- local(quo(foo))
expr_print(local_quo)

wrapper_quo <- local(quo(bar(!!local_quo, baz)))
expr_print(wrapper_quo)
}
