% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_riverdistance.R
\name{homerange}
\alias{homerange}
\title{Home Range}
\usage{
homerange(unique = NULL, survey = NULL, seg, vert, rivers, map = FALSE,
  algorithm = NULL, main = NULL, ...)
}
\arguments{
\item{unique}{A vector of unique identifiers for each fish.  If the default (\code{NULL}) is used, the function will assume all observations come from a single individual.}

\item{survey}{A vector of survey identifiers for each fish.  This argument is not needed for home range calculation, but can affect plotting (see \link{plot.homerange}).}

\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{map}{Deprecated, use \link{plot.homerange} for plotting instead.  Originally, whether to produce sanity-check maps
of observed locations and calculated home range for each fish.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}

\item{main}{Deprecated, use \link{plot.homerange} for plotting instead.  Originally, plot title, if \code{map} is set to \code{TRUE}.  If unspecified, the unique ID will be used for the title.}

\item{...}{Deprecated, use \link{plot.homerange} for plotting instead.  Originally, additional plotting arguments, if \code{map} is set to \code{TRUE}.}
}
\value{
An object of the \link{homerange-class}.  The \code{$ranges} element is a data frame with two columns: \code{$ID} is a list of unique fish
  (as specified by \code{unique=}), and \code{$range} is calculated minimum
  home range, in the units of the coordinate system (this will likely be
  meters).  The other elements are used for plotting, see \link{homerange-class} for more details.
}
\description{
Returns the minimum observed home range for multiple
  observations of each individual fish.
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)
ranges <- with(fakefish, homerange(unique=fish.id, survey=flight, seg=seg, vert=vert, rivers=Gulk))
ranges

# 19 plots will be produced, recommend calling par(mfrow=c(4,5))
plot(ranges)
plot(ranges,cumulative=TRUE,label=TRUE)

homerangeoverlap(ranges)

plothomerangeoverlap(ranges)
with(fakefish, riverpoints(seg=seg, vert=vert, rivers=Gulk))
}
\author{
Matt Tyers
}
\seealso{
\link{plot.homerange}, \link{homerangeoverlap}, \link{plothomerangeoverlap}
}

