% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{muck}
\alias{muck}
\title{Calculate the amount of muck/contamination to explain an observed C14 age}
\usage{
muck(
  y.obs,
  y.target,
  F.contam = 1,
  decimals = 3,
  visualise = TRUE,
  talk = TRUE,
  target.col = "black",
  observed.col = "blue",
  contamination.col = "red",
  target.pch = 20,
  observed.pch = 18,
  contamination.pch = 17,
  true.name = "target",
  xlab = "contamination (\%)",
  ylab = "F14C",
  ylim = c(),
  bty = "l"
)
}
\arguments{
\item{y.obs}{the observed radiocarbon age}

\item{y.target}{the target radiocarbon age}

\item{F.contam}{the F14C of the contamination. Set at 1 for carbon of modern radiocarbon age, at 0 for 14C-free carbon, or anywhere inbetween.}

\item{decimals}{Rounding of the output. Since details matter here, the default is to provide 5 decimals.}

\item{visualise}{By default, a plot is made to visualise the target and observed F14C values, together with the inferred contamination.}

\item{talk}{Whether or not to report the calculations made. Defaults to \code{talk=TRUE}.}

\item{target.col}{Colour for the target values. Defaults to black.}

\item{observed.col}{Colour for the observed values. Defaults to blue.}

\item{contamination.col}{Colour for the contamination values. Defaults to red.}

\item{target.pch}{Icon for the target. Defaults to a filled circle.}

\item{observed.pch}{Icon for the observed. Defaults to a diamond}

\item{contamination.pch}{Icon for the contamination. Defaults to a triangle.}

\item{true.name}{Name of the label of the true/target date}

\item{xlab}{Name of the x-axis. Defaults to 'contamination (\%)'.}

\item{ylab}{Name of the y-axis. Defaults to 'F14C'.}

\item{ylim}{Limits of the y-axis. Calculated automatically by default.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}
}
\value{
The required contamination (as percentage), as well as a plot
}
\description{
Given an observed and a target radiocarbon age, calculate the amount of contamination required to explain the observed age.
}
\examples{
  muck(600, 2000, 1)
}
\author{
Maarten Blaauw
}
