\name{map.eda8}
\alias{map.eda8}
\title{ Plot a Symbol Map of Data Based on their Percentiles }
\description{
Displays a simple map where the data are represented at their spatial locations by symbols indicating within which group defined by the data's 2nd, 5th, 25th, 50th, 75th, 95th and 98th percentiles plotted a data value falls. The colours of the symbols may be optionally changed.  Optionally a legend (two options) may be added to the map.
}
\usage{
map.eda8(xx, yy, zz, sfact = 1, xlab = "Easting", ylab = "Northing", 
	zlab = deparse(substitute(zz)), main = "", ifgrey = FALSE,  
	symcolr = NULL, tol = 0.04, iflgnd = FALSE, pctile = FALSE,
        title = deparse(substitute(zz)), ...)
}
\arguments{
  \item{xx}{ name of the x-axis spatial coordinate, the eastings. }
  \item{yy}{ name of the y-axis spatial coordinate, the northings. }
  \item{zz}{ name of the variable to be plotted. }
  \item{sfact}{ controls the absolute size of the plotted symbols, by default \code{sfact = 1}. Increasing sfact results in larger symbols. }
  \item{xlab}{ a title for the x-axis, defaults to \code{Easting}. }
  \item{ylab}{ a title for the y-axis, defaults to \code{Northing}. }
  \item{zlab}{ by default, \code{zlab = deparse(substitute(zz))}, a map title is generated by appending the input variable name text string to \code{"EDA Percentile Based Map for "}. Alternative titles may be generated, see Details below. }
  \item{main}{ an alternative map title, see Details below.}
  \item{ifgrey}{ set \code{ifgrey = TRUE} if a grey-scale map is required, see Details below. }
  \item{symcolr}{ the default is a colour map and default colours are provided, deeper blues for lower values, green for the middle 50\% of the data, and oranges and reds for higher values. A set of alternate symbol colours can be provided by defining \code{symcolr}, see Details below. }
  \item{tol}{ a parameter used to ensure the area included within the neatline around the map is larger than the distribution of the points so that the plotted symbols fall within the neatline. By default \code{tol = 0.04}, if more clearance is required increase the value of \code{tol}. }
  \item{iflgnd}{ the default is no legend.  If a legend is required set \code{iflegnd = TRUE}, following the plotting of the data the cursor will be activated, locate that at the top left corner of the desired legend position and \sQuote{left button} on the pointing device.  There are two legends to choose from, see \code{pctile} below. }
  \item{pctile}{ the default legend displays the range of values each symbol represents.  If \code{pctile = TRUE} the range of percentiles will be displayed instead of their actual values. }
  \item{title}{ a short title for the legend, e.g., \code{title = "Cu (mg/kg"}.  The default is the variable name. } 
  \item{\dots}{ further arguments to be passed to methods.  For example, if it is required to make the map title smaller, add \code{cex.main = 0.9} to reduce the font size by 10\%. }
}
\details{
The selected percentiles, 2nd, 5th, 25th, 50th, 75th, 95th and 98th, divide the data into 8 groups. Values below the median are represented by increasingly larger deeper blue circles below the 25th percentile (Q1), and values above the 75th percentile (Q3) by increasingly larger orange and red squares. The mid 50\% of the data are represented by green symbols, circles for the median (Q2) to Q1, and squares for the median (Q2) to Q3.

A summary table of the values of the symbol intervals, the number of values plotting as each symbol, and symbol shapes, sizes and colours is displayed on the current device.

If \code{zlab} and \code{main} are undefined a default a map title is generated by appending the input variable name text string to \code{"EDA Percentile Based Map for "}. If no map title is required set \code{zlab = ""}, and if some user defined map title is required it should be defined in \code{main}, e.g. \code{main = "Map Title Text"}.

If the grey-scale option is chosen the symbols are plotted 100\% black for the far outliers, 85\% black for the near outliers, 70\% black for values within the whiskers, and 60\% black for values falling within the middle 50\% of the data.

The default colours, \code{symcolr = c(25, 22, 20, 13, 13, 6, 4, 1)}, are selected from the \code{rainbow(36)} pallette, and alternate colour schemes need to be selected from the same palette.  See \code{\link{display.rainbow}} for the available colours. It is essential that 8 colours be provided, e.g., \code{symcolr = c(27, 24, 22, 12, 12, 5, 3, 36)}, if exactly 8 are not provided the default colours will be displayed.
}
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data vector, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any data vectors including \code{NA}s are removed prior to displaying the plot.

In some R installations the generation of multi-panel displays and the use of function eqscplot from package MASS causes warning messages related to graphics parameters to be displayed on the current device. These may be suppressed by entering \code{options(warn = -1)} on the R command line, or that line may be included in a \sQuote{first} function prepared by the user that loads the \sQuote{rgr} package, etc.
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{display.rainbow}}, \code{\link{ltdl.fix.df}}, \code{\link{remove.na}} }  
\examples{ 
## Make test data available
data(kola.o)
attach(kola.o)

## Plot a default symbol map
map.eda8(UTME, UTMN, Cu)

## Plot a more appropriately labelled map
map.eda8(UTME/1000, UTMN/1000, Cu, 
	xlab = "Kola Project UTM Eastings (km)",
	ylab = "Kola Project UTM Northings (km)") 

## Plot a grey-scale equivalent of the above map
map.eda8(UTME/1000, UTMN/1000, Cu, ifgrey = TRUE,
	xlab = "Kola Project UTM Eastings (km)",
	ylab = "Kola Project UTM Northings (km)") 

## Plot the same map with an alternate colour scheme
map.eda8(UTME/1000, UTMN/1000, Cu,
	xlab = "Kola Project UTM Eastings (km)",
	ylab = "Kola Project UTM Northings (km)",
	symcolr = c(27, 24, 22, 12, 12, 5, 3, 36)) 

## Detach test data
detach(kola.o) 
}
\keyword{ hplot }


