/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.memory.trailing.trail.IOperationTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedTrail;
import org.chocosolver.memory.trailing.trail.chunck.OperationWorld;

public class ChunckedOperationTrail
extends ChunckedTrail<OperationWorld>
implements IOperationTrail {
    private final int ws;
    private final double loadfactor;

    public ChunckedOperationTrail(int ws, int nbWorlds, double loadfactor) {
        this.worlds = new OperationWorld[nbWorlds];
        this.ws = ws;
        this.loadfactor = loadfactor;
        this.current = new OperationWorld(ws, loadfactor);
        ((OperationWorld[])this.worlds)[0] = this.current;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (((OperationWorld[])this.worlds)[worldIndex] == null) {
            this.current = new OperationWorld(this.ws, this.loadfactor);
            ((OperationWorld[])this.worlds)[worldIndex] = (OperationWorld)this.current;
        } else {
            this.current = ((OperationWorld[])this.worlds)[worldIndex];
            ((OperationWorld)this.current).clear();
        }
        if (worldIndex == ((OperationWorld[])this.worlds).length - 1) {
            this.resizeWorlds();
        }
    }

    private void resizeWorlds() {
        int newCapacity = (int)((double)((OperationWorld[])this.worlds).length * this.loadfactor);
        OperationWorld[] tmp = new OperationWorld[newCapacity];
        System.arraycopy(this.worlds, 0, tmp, 0, ((OperationWorld[])this.worlds).length);
        this.worlds = tmp;
    }

    @Override
    public void savePreviousState(IOperation operation) {
        ((OperationWorld)this.current).savePreviousState(operation);
    }

    @Override
    public void savePreviousStateAt(IOperation operation, int at, int currentWorldIndex) {
        ((OperationWorld[])this.worlds)[at].savePreviousState(operation);
    }
}

