/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.constraints;

import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.variables.IntVar;
import org.restopt.RestoptProblem;
import org.restopt.choco.PropIIC;
import org.restopt.constraints.AbstractRestoptConstraint;
import org.restopt.exception.RestoptException;

public class IntegralIndexOfConnectivityConstraint
extends AbstractRestoptConstraint {
    public static final String KEY_IIC = "iic";
    protected int minIIC;
    protected int maxIIC;
    protected int distanceThreshold;
    protected int precision;
    protected IntVar iic;

    public IntegralIndexOfConnectivityConstraint(RestoptProblem restoptProblem, double minIIC, double maxIIC, int distanceThreshold, int precision) throws RestoptException {
        super(restoptProblem);
        if (minIIC < 0.0 || maxIIC > 1.0) {
            throw new RestoptException("min and max IIC must be comprised between 0 and 1");
        }
        if (distanceThreshold <= 0) {
            throw new RestoptException("Distance threshold for IIC must be at least 1");
        }
        this.minIIC = (int)(minIIC * Math.pow(10.0, precision));
        this.maxIIC = (int)(maxIIC * Math.pow(10.0, precision));
        this.distanceThreshold = distanceThreshold;
        this.precision = precision;
        this.problem.setIICConstraint(this);
    }

    @Override
    public void post() {
        if (this.problem.getAdditionalVariables().containsKey(KEY_IIC)) {
            this.iic = this.problem.getAdditionalVariables().get(KEY_IIC);
            this.getModel().arithm(this.iic, ">=", this.minIIC).post();
            this.getModel().arithm(this.iic, "<=", this.maxIIC).post();
        } else {
            this.iic = this.problem.getModel().intVar(this.minIIC, this.maxIIC);
            Constraint consIIC = new Constraint("IIC_constraint", new PropIIC(this.problem.getHabitatGraphVar(), this.iic, this.problem.getGrid(), this.problem.getLandscapeArea(), this.distanceThreshold + 1, this.precision, false));
            this.problem.getModel().post(consIIC);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public IntVar getIic() {
        return this.iic;
    }
}

