% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_uv_mv}
\alias{rm_uv_mv}
\title{Combine univariate and multivariable regression tables}
\usage{
rm_uv_mv(
  uvsumTable,
  mvsumTable,
  covTitle = "",
  vif = FALSE,
  caption = NULL,
  tableOnly = FALSE,
  chunk_label
)
}
\arguments{
\item{uvsumTable}{Output from rm_uvsum, with tableOnly=TRUE}

\item{mvsumTable}{Output from rm_mvsum, with tableOnly=TRUE}

\item{covTitle}{character with the names of the covariate (predictor) column.
The default is to leave this empty for output or, for table only output to
use the column name 'Covariate'.}

\item{vif}{boolean indicating if the variance inflation factor should be
shown if present in the mvsumTable. Default is FALSE.}

\item{caption}{table caption}

\item{tableOnly}{boolean indicating if unformatted table should be returned}

\item{chunk_label}{only used if output is to Word to allow cross-referencing}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
This function will combine rm_uvsum and rm_mvsum outputs into a single table.
The tableOnly argument must be set to TRUE when tables to be combined are
created. The resulting table will be in the same order as the uvsum table
and will contain the same columns as the uvsum and mvsum tables, but the
p-values will be combined into a single column. There must be a variable overlapping
between the uvsum and mvsum tables and all variables in the mvsum table
must also appear in the uvsum table.
}
\examples{
require(survival)

uvTab <- rm_uvsum(response = c('os_time','os_status'),
covs=c('age','sex','baseline_ctdna','l_size','change_ctdna_group'),
data=pembrolizumab,tableOnly=TRUE)
mv_surv_fit <- coxph(Surv(os_time,os_status)~age+sex+
baseline_ctdna+l_size+change_ctdna_group, data=pembrolizumab)
uvTab <- rm_mvsum(mv_surv_fit)

#linear model
uvtab<-rm_uvsum(response = 'baseline_ctdna',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab,tableOnly=TRUE)
lm_fit=lm(baseline_ctdna~age+sex+l_size+tmb,data=pembrolizumab)
mvtab<-rm_mvsum(lm_fit,tableOnly = TRUE)
rm_uv_mv(uvtab,mvtab,tableOnly=TRUE)

#logistic model
uvtab<-rm_uvsum(response = 'os_status',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab,family = binomial,tableOnly=TRUE)
logis_fit<-glm(os_status~age+sex+l_size+pdl1+tmb,data = pembrolizumab,family = 'binomial')
mvtab<-rm_mvsum(logis_fit,tableOnly = TRUE)
rm_uv_mv(uvtab,mvtab,tableOnly=TRUE)
}
\seealso{
\code{\link{rm_uvsum}},\code{\link{rm_mvsum}}
}
