% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_participants.R
\name{report_participants}
\alias{report_participants}
\title{Reporting the participant data}
\usage{
report_participants(
  data,
  age = NULL,
  sex = NULL,
  gender = NULL,
  education = NULL,
  participants = NULL,
  group = NULL,
  spell_n = FALSE,
  digits = 1,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{age}{The name of the column containing the age of the participant.}

\item{sex}{The name of the column containing the sex of the participant. The
classes should be one of \code{c("Male", "M", "Female", "F")}. Note that
you can specify other characters here as well (e.g., \code{"Intersex"}), but
the function will group all individuals in those groups as \code{"Other"}.}

\item{gender}{The name of the column containing the gender of the
The classes should be one of \code{c("Man", "M", "Woman", "F", "Non-Binary", "N")}. Note that you can specify other characters here as well
(e.g., \code{"Gender Fluid"}), but the function will group all individuals in
those groups as \code{"Non-Binary"}.}

\item{education}{The name of the column containing education information.}

\item{participants}{The name of the participants' identifier column (for
instance in the case of repeated measures).}

\item{group}{A character vector indicating the name(s) of the column(s) used
for stratified description.}

\item{spell_n}{Fully spell the sample size (\code{"Three participants"}
instead of \code{"3 participants"}).}

\item{digits}{Number of significant digits.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A character vector with description of the "participants", based on
the information provided in \code{data}.
}
\description{
A helper function to help you format the participants data (age, sex, ...) in
the participants section.
}
\examples{
library(report)
data <- data.frame(
  "Age" = c(22, 23, 54, 21, 8, 42),
  "Sex" = c("Intersex", "F", "M", "M", "M", "F"),
  "Gender" = c("N", "W", "W", "M", "M", "M")
)

report_participants(data, age = "Age", sex = "Sex")

# Years of education (relative to high school graduation)
data$Education <- c(0, 8, -3, -5, 3, 5)
report_participants(data,
  age = "Age", sex = "Sex", gender = "Gender",
  education = "Education"
)

# Education as factor
data$Education2 <- c(
  "Bachelor", "PhD", "Highschool",
  "Highschool", "Bachelor", "Bachelor"
)
report_participants(data, age = "Age", sex = "Sex", gender = "Gender", education = "Education2")


# Repeated measures data
data <- data.frame(
  "Age" = c(22, 22, 54, 54, 8, 8),
  "Sex" = c("I", "F", "M", "M", "F", "F"),
  "Gender" = c("N", "W", "W", "M", "M", "M"),
  "Participant" = c("S1", "S1", "s2", "s2", "s3", "s3")
)

report_participants(data, age = "Age", sex = "Sex", gender = "Gender", participants = "Participant")

# Grouped data
data <- data.frame(
  "Age" = c(22, 22, 54, 54, 8, 8, 42, 42),
  "Sex" = c("I", "I", "M", "M", "F", "F", "F", "F"),
  "Gender" = c("N", "N", "W", "M", "M", "M", "Non-Binary", "Non-Binary"),
  "Participant" = c("S1", "S1", "s2", "s2", "s3", "s3", "s4", "s4"),
  "Condition" = c("A", "A", "A", "A", "B", "B", "B", "B")
)

report_participants(data,
  age = "Age",
  sex = "Sex",
  gender = "Gender",
  participants = "Participant",
  group = "Condition"
)

# Spell sample size
paste(
  report_participants(data, participants = "Participant", spell_n = TRUE),
  "were recruited in the study by means of torture and coercion."
)
}
