% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renv.R
\name{activate}
\alias{activate}
\title{Activate a Project}
\usage{
activate(project = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Use \code{activate()} to write the infrastructure needed to ensure that
newly-launched \R projects will load the project's private library on launch,
alongside any other project-specific state recorded for the project.
}
\examples{
\dontrun{

# activate the current project
renv::activate()

# activate a separate project
renv::activate("~/projects/analysis")

}
}
\seealso{
Other renv: \code{\link{deactivate}()}
}
\concept{renv}
