% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{fitted.block_lm}
\alias{fitted.block_lm}
\title{Extract model fitted values.}
\usage{
\method{fitted}{block_lm}(object, num = NULL, ...)
}
\arguments{
\item{object}{An object of class "\code{block_lm}", usually, a result of a
call to \code{\link{build_model}}.}

\item{num}{Numeric vector with the index of model(s) from which to return the
fitted values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The fitted values of block(s) `num`, or if `num` is NULL, a list of
  fitted values from all blocks.
}
\description{
\code{fitted} method for class "\code{block_lm}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
fitted(model1)  # returns both blocks 1 and 2

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
fitted(model2, num=2)  # returns second block
}
\seealso{
\code{\link{build_model}}, \code{coef.block_lm},
  \code{residuals.block_lm}
}

