% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{beta.glm}
\alias{beta.glm}
\title{Standardized coeffients of a model.}
\usage{
\method{beta}{glm}(model, x = TRUE, y = FALSE, skip = NULL, ...)
}
\arguments{
\item{model}{A fitted generalized linear model of type 'glm'.}

\item{x}{Logical. Whether or not to standardize predictor variables.}

\item{y}{Logical. Whether or not to standardize criterion variables.}

\item{skip}{A string vector indicating any variables you do \emph{not} wish
to be standarized.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
Returns the summary of a generalized linear model, with the output
  showing the beta coefficients, standard error, t-values, and p-values for
  each predictor.
}
\description{
\code{beta.glm} returns the summary of a linear model where all variables
have been standardized.
}
\details{
This function takes a generalized linear regression model and standardizes
the variables, in order to produce standardized (i.e., beta) coefficients
rather than unstandardized (i.e., B) coefficients.

Note: Unlike \code{\link{beta.lm}}, the \code{y} parameter is set to FALSE by
default, to avoid issues with some family functions (e.g., binomial).
}
\examples{
# mtcars data
model1 <- glm(vs ~ wt + hp, data=mtcars, family='binomial')
beta(model1)  # wt and hp standardized, vs is not by default
}
\seealso{
\code{\link{beta.glm}}
}

