% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refitME_package.R
\name{MCEMfit_CR}
\alias{MCEMfit_CR}
\title{Function for fitting \code{VGAM} capture-recapture (CR) model using the MCEM algorithm}
\source{
See \url{https://github.com/JakubStats/refitME} for an RMarkdown tutorial with examples.
}
\usage{
MCEMfit_CR(
  mod,
  sigma.sq.u,
  sigma.sq.e = 1,
  B = 50,
  epsilon = 1e-05,
  silent = FALSE
)
}
\arguments{
\item{mod}{: a \code{vglm/vgam} object (this is the naive CR model). Make sure the first \eqn{p} input predictor variables in the naive model are the selected error-contaminated variables.}

\item{sigma.sq.u}{: measurement error (ME) variance. A scalar if there is only one error-contaminated predictor variable, otherwise this must be stored as a vector (of ME variances) or a matrix if the ME covariance matrix is known.}

\item{sigma.sq.e}{: variance of the true predictor (\eqn{X}).}

\item{B}{: the number of Monte Carlo replication values (default is set to 50).}

\item{epsilon}{: a set convergence threshold (default is set to 0.00001).}

\item{silent}{: if \code{TRUE}, the convergence message (which tells the user if the model has converged and reports the number of iterations required) is suppressed (default is set to \code{FALSE}).}
}
\value{
\code{MCEMfit_CR} returns model coefficient and population size estimates with standard errors and the effective sample size.
}
\description{
Function for fitting \code{VGAM} capture-recapture (CR) model using the MCEM algorithm where covariates have measurement error.
}
\section{Warning}{

This function is still under development. Currently the function can only fit the CR model used in the manuscript. IT DOES NOT SUPPORT ALL \code{VGAM} families.
}

\examples{
# A VGAM example using the Prinia flaviventris capture-recapture data.

library(refitME)
library(VGAM)

data(Priniadata)

tau <- 17   # No. of capture occasions.
w1 <- Priniadata$w1 # Bird wing length predictor.

CR_naiv <- vglm(cbind(cap, noncap) ~ w1,
   VGAM::posbinomial(omit.constant = TRUE, parallel = TRUE ~ w1),
   data = Priniadata, trace = FALSE)

sigma.sq.u <- 0.37 # ME variance.

CR_MCEM <- refitME(CR_naiv, sigma.sq.u)

detach(package:VGAM)

}
\references{
Stoklosa, J., Hwang, W-H., and Warton, D.I. \pkg{refitME}: Measurement Error Modelling using Monte Carlo Expectation Maximization in \proglang{R}.
}
\seealso{
\code{\link{MCEMfit_glm}}
}
\author{
Jakub Stoklosa, Wen-Han Hwang and David I. Warton.
}
