% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{practicalRangeCMB}
\alias{practicalRangeCMB}
\title{Practical range for covariance  function}
\usage{
practicalRangeCMB(cov.model, phi, kappa = 0.5, correlation = 0.05, ...)
}
\arguments{
\item{cov.model}{A type of the correlation function. Available choices are: "matern",
"exponential","spherical", "powered.exponential", "cauchy", "gencauchy", "pure.nugget",
"askey", "c2wendland", "c4wendland", "sinepower", "multiquadric".}

\item{phi}{The range parameter as documented in \code{\link{covmodelCMB}}}

\item{kappa}{A smoothness parameter of the correlation function.}

\item{correlation}{A correlation threshold (default is 0.05)}

\item{...}{other optimisation parameters}
}
\value{
Value of the practical range for the covariance  function specified in \code{\link{covmodelCMB}}
}
\description{
This function computes the practical range for covariance  functions on spheres.
The function extends \code{\link[geoR]{practicalRange}} from the
package \strong{geoR} to additional covariance models on spheres.
}
\details{
The practical(effective)  range for a covariance  function is the distance at which
a covariance function first time reaches the specified value \code{correlation}.  For
covariance functions on  spheres the practical range does not exceed \eqn{pi}, the
distance beyond which a covariance function is not defined. For the covariance
functions "spherical", "askey", "c2wendland", "c4wendland" their practical ranges
are equal to lengths of their support.
}
\examples{

practicalRangeCMB(cov.model = "sinepower", phi = 0.1,  kappa = 0.5)
practicalRangeCMB(cov.model = "askey", phi = 0.1,  kappa = 0.5)

}
\references{
\strong{geoR} package, \code{\link[geoR]{practicalRange}}, \code{\link{covmodelCMB}}
}
