% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shape.R
\name{add_shape}
\alias{add_shape}
\title{Add Shape}
\usage{
add_shape(scene, shape = NULL)
}
\arguments{
\item{scene}{The scene to add the shape.}

\item{shape}{The mesh to add to the scene.}
}
\value{
Scene with shape added.
}
\description{
Add shape to the scene.
}
\examples{
if(rayvertex:::run_documentation()) {
#Generate several spheres in the cornell box
scene = generate_cornell_mesh()
set.seed(1)

for(i in 1:30) {
 col = hsv(runif(1))
 scene = add_shape(scene, sphere_mesh(position=runif(3)*400+155/2,
                                      material=material_list(diffuse=col, type="phong",
                                                             ambient=col,ambient_intensity=0.2), 
                                      radius=30))
}
rasterize_scene(scene, light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
