% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-fir.R
\name{firls}
\alias{firls}
\title{Least-squares linear-phase \code{FIR} filter design}
\usage{
firls(N, freq, A, W = NULL, ftype = "")
}
\arguments{
\item{N}{filter order, must be even (if odd, then will be increased by one)}

\item{freq}{vector of frequency points in the range from 0 to 1, where 1
corresponds to the \code{Nyquist} frequency.}

\item{A}{vector of the same length as \code{freq} containing the desired
amplitude at each of the points specified in \code{freq}.}

\item{W}{weighting function that contains one value for each band that
weights the mean squared error in that band. \code{W} must be half the
length of \code{freq}.}

\item{ftype}{transformer type; default is \code{""}; alternatively,
\code{'h'} or \code{'hilbert'} for 'Hilbert' transformer.}
}
\value{
The \code{FIR} filter coefficients with class \code{'Arma'}.
The moving average coefficient is a vector of length \code{n+1}.
}
\description{
Produce a linear phase filter from the weighted mean squared such that error
in the specified bands is minimized.
}
