% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ratios.R
\name{ratio.DT1_DT2}
\alias{ratio.DT1_DT2}
\title{ratio.DT1_DT2}
\usage{
ratio.DT1_DT2(DT1, DT2, vars = NULL, group1.vars, group2.vars = NULL,
  ratio_type = "simple", Errors = FALSE, Error_method = "gauss",
  var_subgroup = NULL, use_only_DT2 = FALSE, DT2_replace = NULL, STD_DT1,
  STD_DT2, minNr_DT1 = 50, minNr_DT2 = 50, return_all = FALSE,
  return_as_list = FALSE)
}
\arguments{
\item{DT1}{data.frame or data.table, samples in rows and elements and other information in columns}

\item{DT2}{data.frame or data.table of DT2 or crust data, samples in rows and elements and other information in columns.}

\item{vars}{optional, character vector of column names of DT1 and DT2, default is function \code{\link{select.VarsElements}}.
Please make sure the columns given in \code{vars} are of class numeric.}

\item{group1.vars}{character vector, column name(s) for subsetting DT1 and DT2}

\item{group2.vars}{optional, column name for subsetting DT1 and DT2 if some entries in \code{group1.vars} are empty.}

\item{ratio_type}{character vector: "simple" calculates DT1/DT2, "clr" calculates in clr-mode, and "alr" calculated in alr-mode.
For further explanations please read clr and alr in package \code{compositions}.}

\item{Errors}{logical, should absolute errors get calculated appended to the list - output? Default is FALSE.
If Errors are set to TRUE it overrides the option \code{return_as_list} and always returns a list.}

\item{Error_method}{method with which the error should be calculated. At the moment you can choose between "gauss" (default) and "biggest".
See Details for explanation.}

\item{var_subgroup}{optional, character vector of one column name of DT1. This option affects the only the error calculation, hence it is ignored if \code{Errors} is set to FALSE.
If provided, DT1 is split into subsets by \code{group1.vars} \emph{and} 'var_subgroup' and the error will calculated for each of these subset.
Please read in the Details for further information.}

\item{use_only_DT2}{logical, default is FALSE. If there are not enough DT2 data of the location should the DT2s of the region be used? If the \code{use_only_DT2} is set to FALSE then the Upper Crust is used for the correction.}

\item{DT2_replace}{optional, if a DT1 sample does not have DT2 data of the corresponding location with this option you can define which data you would like to use as DT2.
Default is the UpperCrust. If you would like to have something else, please provide a named vector/ one-row data.table with values used instead of DT2}

\item{STD_DT1}{optional, data.frame or data.table object for calculating errors for DT1, e.g. the standards. Please see Details. If left empty a default of 5.2\% relative error is used.}

\item{STD_DT2}{optional, data.frame or data.table object for calculating errors for DT2, e.g. the standards. Please see Details. If left empty a default of 5.2\% relative error is used.}

\item{minNr_DT1}{minimum numbers of samples/observations in DT1 for calculating a relative error of observations.
If the number of observations of DT1 is smaller than \code{minNr_DT1} the error is calculated via the data set \code{STD_DT1}.
Default is 50.}

\item{minNr_DT2}{minimum numbers of samples/observations in DT2 for calculating a relative error of observations.
If the number of observations of DT1 is smaller than \code{minNr_DT2} the error is calculated via the data set \code{STD_DT2}.
Default is 50.}

\item{return_all}{logical, should \emph{all} used data sets be returned as a list? Default is FALSE.
If set to TRUE the list contains DT1, DT2, vars, ratios, and optional additional ratios_error, DT1_error and DT2_error.}

\item{return_as_list}{logical, should the result get returned as list? Default is FALSE.
If set to FALSE and \code{Errors} is set to TRUE a column \code{type_of_data} is appended.
This option is ignored if option 'return_all' is set to TRUE.}
}
\value{
The function returns either a data.table, data.frame or a list controlled by the option \code{return_as_list}.
If \code{return_as_list} to FALSE a data.frame (or data.table if DT1 is of class data.table) is returned.
If option \code{Errors} is set to TRUE ratios and error are combined into one object and a column \code{type_of_data} is appended with the entries \emph{ratio} and \emph{ratio_error} respectively.
If \code{return_as_list} to TRUE the DT1-DT2-ratios are named in the list as "ratios" and, if \code{Errors} is set to TRUE the absolute errors of the ratios are saved in the list as "ratios_error".
If 'return_all' is set to TRUE a list with the following entries will be returned:

[[1]] "DT1", [[2]] "DT2", [[3]] "vars", [[4]] "ratios" and if \code{Errors} is set to TRUE additionally [[5]] "ratios_error", [[6]] "DT1_error", [[7]] "DT2_error".
}
\description{
The function calculates ratio between DT1 and DT2 for all variables specified in \code{vars} by the columns \code{group1.vars} (and optional \code{group2.vars}).
Generally DT1 and DT2 have to have the columns in common which are given in \code{group1.vars}, optional \code{group2.vars} and \code{vars}.
If DT2 has different number of rows than DT1 a 'new DT2' with corresponding dimensions is prepared by the function \code{\link{preparation.DT2}}.
At the moment there are three different options for calculating the ratios:
\itemize{
    \item "simple"
    \item "clr"
    \item "alr"
}
For more details please refer to \code{\link{preparation.DT2}} and section Details.
}
\details{
To calculate the ratios the functions internally calls \code{\link{preparation.DT2}} to create a data set 'new DT2' from the variables \code{vars} of DT2, which has equal number of rows to DT1.
Then the division is done by the now corresponding data sets by the method given in 'ratio_type'.

The method "simple" is a simple division between DT1 and DT2:
\deqn{
\frac{DT1[vars]}{DT2[vars]}
}

The methods "clr" and "alr" should be considered if the data contain so called \emph{compositional data} as defined by Aitchison, J. (1986): "The statistical analysis of compositional data".

The method "clr" is calculated by:
\deqn{
 ln \left(\frac{DT1[vars_{i}]}{DT2[vars_{i}]} * \frac{g(x)^{DT2[vars]}}{g(x)^{DT1[vars]}}\right)_{i=1,\dots, D}
}
whereof the function g(x) stands for:
\deqn{g(x) = \sqrt[D]{DT[vars_1] \cdot DT[vars_2] \cdots DT[vars_D]} }

The method "alr" is calculated by:
\deqn{
ln \left(\frac{DT1[vars_{i}]}{DT2[vars_{i}]} * \frac{DT2[vars_n]}{DT1[vars_n]}\right)_{i=1,\dots, n, \dots, D}
}

Calculating the absolute error for the ratios requires calculating the absolute errors of DT1 and DT2, too.
For calculating the errors of DT1 and DT2 the function \code{\link{relError_dataset}} is used.
Accordingly the options for \code{STD_DT1} and \code{STD_DT2} are passed to the option \code{STD} in \code{relError_dataset}.
If STD_DT1 and/or STD_DT2 are left empty the default of 5.2\% relative error is used.
Also the options \code{minNr_DT1} and \code{minNr_DT2} are passed to the option \code{minNr} in \code{relError_dataset}.

The \code{Error_method} determines how the absolute error of the ratios is calculated.
The error method "gauss" refers to the error propagation after Gauss:
\deqn{
\Delta x =  \frac{\Delta DT1}{DT2} - DT1 * \frac{\Delta DT2}{DT2^2}
}
The error method "biggest" refers to the maximum error after Gauss:
\deqn{
\Delta x =  \frac{\Delta DT1}{DT2} + DT1 * \frac{\Delta DT2}{DT2^2}
}

For example:
If you have in DT1 plant samples with \code{group1.vars = "Location"} the error function would calculate the relative standard deviation for all plants of one location.
But maybe you have very different plants in one location so setting \code{var_subgroup = "Species"} the error function will calculate the relative standard deviation for each plant species per location, if there are more species per location than given in \code{minNr_DT1}.
Suppose DT2 are soil data with several samples per location.
If \code{group1.vars = "Location"} than the function calls \code{\link{preparation.DT2}} and calculates a mean for each location from the data set.
The ratio from plant to soil and the absolute errors of the ratios is then calculated for each plant sample to a mean of soils from one location.
}
\seealso{
Other ratio functions: \code{\link{Correction.AdheringParticles}},
  \code{\link{preparation.DT2}},
  \code{\link{ratio.append_smallest}}
}
\author{
Solveig Pospiech
}
