% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/compare_props.R
\name{compare_props}
\alias{compare_props}
\title{Compare proportions across groups}
\usage{
compare_props(dataset, cp_var1, cp_var2, data_filter = "", cp_levels = "",
  cp_alternative = "two.sided", cp_sig_level = 0.95, cp_adjust = "none")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{cp_var1}{A grouping variable to split the data for comparisons}

\item{cp_var2}{The variable to calculate proportions for}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{cp_levels}{The factor level selected for the proportion comparison}

\item{cp_alternative}{The alternative hypothesis ("two.sided", "greater" or "less")}

\item{cp_sig_level}{Span of the confidence interval}

\item{cp_adjust}{Adjustment for multiple comparisons ("none" or "bonf" for Bonferroni)}
}
\value{
A list of all variables defined in the function as an object of class compare_props
}
\description{
Compare proportions across groups
}
\details{
See \url{http://vnijs.github.io/radiant/quant/compare_props.html} for an example in Radiant
}
\examples{
result <- compare_props("titanic", "pclass", "survived")
}
\seealso{
\code{\link{summary.compare_props}} to summarize results

\code{\link{plot.compare_props}} to plot results
}

