% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_props.R
\name{compare_props}
\alias{compare_props}
\title{Compare sample proportions across groups}
\usage{
compare_props(dataset, var1, var2, levs = "",
  alternative = "two.sided", conf_lev = 0.95, comb = "",
  adjust = "none", data_filter = "")
}
\arguments{
\item{dataset}{Dataset}

\item{var1}{A grouping variable to split the data for comparisons}

\item{var2}{The variable to calculate proportions for}

\item{levs}{The factor level selected for the proportion comparison}

\item{alternative}{The alternative hypothesis ("two.sided", "greater" or "less")}

\item{conf_lev}{Span of the confidence interval}

\item{comb}{Combinations to evaluate}

\item{adjust}{Adjustment for multiple comparisons ("none" or "bonf" for Bonferroni)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables defined in the function as an object of class compare_props
}
\description{
Compare sample proportions across groups
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/compare_props.html} for an example in Radiant
}
\examples{
compare_props(titanic, "pclass", "survived") \%>\% str()

}
\seealso{
\code{\link{summary.compare_props}} to summarize results

\code{\link{plot.compare_props}} to plot results
}
