% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{wind.dl}
\alias{wind.dl}
\alias{read.rWind}
\title{Wind-data download}
\usage{
wind.dl(
  yyyy,
  mm,
  dd,
  tt,
  lon1,
  lon2,
  lat1,
  lat2,
  type = "read-data",
  trace = 1
)

read.rWind(file)
}
\arguments{
\item{yyyy}{Selected year.}

\item{mm}{Selected month.}

\item{dd}{Selected day.}

\item{tt}{Selected time. There are currently several options at the GFS
database: 00:00 - 03:00 - 06:00 - 09:00 - 12:00 - 15:00 - 18:00 - 21:00
(UTC).}

\item{lon1}{Western longitude}

\item{lon2}{Eastern longitude}

\item{lat1}{Southern latitude}

\item{lat2}{Northern latitude}

\item{type}{Output type. "read-data" is selected by default, creating an R
object. If you choose "csv", wind.dl create a a CSV file in your working
directory named "wind_yyyy_mm_dd_tt.csv".}

\item{trace}{if trace = 1 (by default) track downloaded files}

\item{file}{file name of the saved ".csv" files.}
}
\value{
"rWind" and "data.frame" class object or .csv file with U and V
vector  components and wind direction and speed for each coordinate
in the study area defined by lon1/lon2 and lat1/lat2.
}
\description{
wind.dl downloads wind data from the Global Forecast System (GFS) of the
USA's National Weather Service (NWS)
(https://www.ncei.noaa.gov/products/weather-climate-models/global-forecast).
Wind data are taken from NOAA/NCEP Global Forecast System (GFS) Atmospheric
Model collection. Geospatial resolution is 0.5 degrees (approximately 50 km),
and wind is calculated for Earth surface, at 10 m. More metadata
information:
https://pae-paha.pacioos.hawaii.edu/erddap/griddap/ncep_global.graph
}
\details{
The output type is determined by type="csv" or type="read-data". If
type="csv" is selected, the function creates a "wind_yyyy_mm_dd_tt.csv" file
that is downloaded at the work directory. If type="read-data" is selected,
an R object (data.frame) is created.
}
\note{
Longitude coordinate are provided by GFS dataset in 0/360 notation
and transformed internally into -180/180. Wind "dir" denotes where the
wind is going (toward), not from where is coming.
}
\examples{

# Download wind for Iberian Peninsula region at 2015, February 12, 00:00
\dontrun{

wind.dl(2015, 2, 12, 0, -10, 5, 35, 45)
}

}
\references{
http://www.digital-geography.com/cloud-gis-getting-weather-data/#.WDOWmbV1DCL

https://pae-paha.pacioos.hawaii.edu/erddap/griddap/ncep_global.graph
}
\seealso{
\code{\link{wind.dl_2}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López (jflopez.bio@gmail.com)
}
\keyword{~gfs}
\keyword{~wind}
