% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions.R
\name{wind.fit}
\alias{wind.fit}
\title{Wind-data fit}
\usage{
wind.fit(X)
}
\arguments{
\item{X}{data.frame generated by wind.dl function from "rWind" package.}
}
\value{
A data.frame prepared to be plotted by R or to be exported as a CSV
file to be used with a GIS software.
}
\description{
wind.fit is used to transform a data.frame obtained from wind.dl. wind.fit
applies trigonometry tools to transform U and V vector wind components in
wind direction and speed features. It also transforms 0-360 longitude
notation obtained from GFS data into -180/180 longitude notation to be used
in GIS (Geographic Information Systems) or for R plots. Moreover, it cleans
column names obtained from wind.dl, deletes "time" column and sorts the data
by latitude.
}
\note{
If you want to calculate wind average from multiple wind datasets
using wind.mean function, you should use U and V vector components rather
than speed and direction values. Please, perform the calculations through
wind.mean directly from the result of wind.dl function before of running
wind.fit
}
\examples{

# Download wind for Iberian Peninsula region at 2015, February 12, 00:00
# wind_data <- wind.dl(2015,2,12,0,-10,5,35,45)

data(wind_data)

# Fit downloaded dataset to be plotted
wind_fitted_data <- wind.fit(wind_data)

# Export as CSV format in your work directory
# write.csv(wind_fitted_data, "wind_data_2015_11_2_Iberian_Peninsula.csv")

}
\references{
https://en.wikipedia.org/wiki/Cross_product
}
\seealso{
\code{\link{wind.dl}}, \code{\link{wind.mean}},
\code{\link{wind2raster}}
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\keyword{~gfs}
\keyword{~wind}
