// Generated by rstantools.  Do not edit by hand.

/*
    rPBK is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rPBK is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rPBK.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_PBK_AD_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'PBK_AD', line 68, column 2 to column 29)",
                                                      " (in 'PBK_AD', line 69, column 2 to column 29)",
                                                      " (in 'PBK_AD', line 70, column 2 to column 35)",
                                                      " (in 'PBK_AD', line 71, column 2 to column 36)",
                                                      " (in 'PBK_AD', line 74, column 2 to column 40)",
                                                      " (in 'PBK_AD', line 75, column 2 to column 21)",
                                                      " (in 'PBK_AD', line 76, column 2 to column 21)",
                                                      " (in 'PBK_AD', line 77, column 2 to column 28)",
                                                      " (in 'PBK_AD', line 78, column 2 to column 28)",
                                                      " (in 'PBK_AD', line 79, column 2 to column 28)",
                                                      " (in 'PBK_AD', line 81, column 4 to column 50)",
                                                      " (in 'PBK_AD', line 82, column 4 to column 50)",
                                                      " (in 'PBK_AD', line 84, column 6 to column 55)",
                                                      " (in 'PBK_AD', line 83, column 22 to line 85, column 5)",
                                                      " (in 'PBK_AD', line 83, column 4 to line 85, column 5)",
                                                      " (in 'PBK_AD', line 80, column 20 to line 86, column 3)",
                                                      " (in 'PBK_AD', line 80, column 2 to line 86, column 3)",
                                                      " (in 'PBK_AD', line 87, column 2 to column 28)",
                                                      " (in 'PBK_AD', line 88, column 2 to column 23)",
                                                      " (in 'PBK_AD', line 89, column 2 to line 98, column 7)",
                                                      " (in 'PBK_AD', line 117, column 2 to column 47)",
                                                      " (in 'PBK_AD', line 118, column 2 to column 48)",
                                                      " (in 'PBK_AD', line 121, column 6 to column 83)",
                                                      " (in 'PBK_AD', line 120, column 26 to line 122, column 5)",
                                                      " (in 'PBK_AD', line 120, column 4 to line 122, column 5)",
                                                      " (in 'PBK_AD', line 119, column 25 to line 123, column 3)",
                                                      " (in 'PBK_AD', line 119, column 2 to line 123, column 3)",
                                                      " (in 'PBK_AD', line 128, column 8 to column 114)",
                                                      " (in 'PBK_AD', line 127, column 29 to line 129, column 7)",
                                                      " (in 'PBK_AD', line 127, column 6 to line 129, column 7)",
                                                      " (in 'PBK_AD', line 126, column 26 to line 130, column 5)",
                                                      " (in 'PBK_AD', line 126, column 4 to line 130, column 5)",
                                                      " (in 'PBK_AD', line 125, column 23 to line 131, column 3)",
                                                      " (in 'PBK_AD', line 125, column 2 to line 131, column 3)",
                                                      " (in 'PBK_AD', line 101, column 2 to column 42)",
                                                      " (in 'PBK_AD', line 102, column 2 to column 42)",
                                                      " (in 'PBK_AD', line 104, column 4 to column 61)",
                                                      " (in 'PBK_AD', line 103, column 25 to line 105, column 3)",
                                                      " (in 'PBK_AD', line 103, column 2 to line 105, column 3)",
                                                      " (in 'PBK_AD', line 106, column 2 to column 42)",
                                                      " (in 'PBK_AD', line 110, column 8 to column 98)",
                                                      " (in 'PBK_AD', line 109, column 29 to line 111, column 7)",
                                                      " (in 'PBK_AD', line 109, column 6 to line 111, column 7)",
                                                      " (in 'PBK_AD', line 108, column 26 to line 112, column 5)",
                                                      " (in 'PBK_AD', line 108, column 4 to line 112, column 5)",
                                                      " (in 'PBK_AD', line 107, column 23 to line 113, column 3)",
                                                      " (in 'PBK_AD', line 107, column 2 to line 113, column 3)",
                                                      " (in 'PBK_AD', line 55, column 2 to column 26)",
                                                      " (in 'PBK_AD', line 56, column 2 to column 21)",
                                                      " (in 'PBK_AD', line 57, column 2 to column 22)",
                                                      " (in 'PBK_AD', line 58, column 9 to column 19)",
                                                      " (in 'PBK_AD', line 58, column 2 to column 35)",
                                                      " (in 'PBK_AD', line 59, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 59, column 2 to column 25)",
                                                      " (in 'PBK_AD', line 60, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 60, column 2 to column 25)",
                                                      " (in 'PBK_AD', line 61, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 61, column 16 to column 22)",
                                                      " (in 'PBK_AD', line 61, column 2 to column 31)",
                                                      " (in 'PBK_AD', line 62, column 8 to column 18)",
                                                      " (in 'PBK_AD', line 62, column 19 to column 24)",
                                                      " (in 'PBK_AD', line 62, column 25 to column 31)",
                                                      " (in 'PBK_AD', line 62, column 2 to column 51)",
                                                      " (in 'PBK_AD', line 63, column 2 to column 10)",
                                                      " (in 'PBK_AD', line 64, column 2 to column 12)",
                                                      " (in 'PBK_AD', line 65, column 2 to column 19)",
                                                      " (in 'PBK_AD', line 68, column 8 to column 14)",
                                                      " (in 'PBK_AD', line 69, column 8 to column 14)",
                                                      " (in 'PBK_AD', line 70, column 8 to column 14)",
                                                      " (in 'PBK_AD', line 70, column 15 to column 21)",
                                                      " (in 'PBK_AD', line 71, column 8 to column 14)",
                                                      " (in 'PBK_AD', line 74, column 9 to column 19)",
                                                      " (in 'PBK_AD', line 74, column 21 to column 27)",
                                                      " (in 'PBK_AD', line 75, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 76, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 77, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 77, column 17 to column 23)",
                                                      " (in 'PBK_AD', line 78, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 78, column 17 to column 23)",
                                                      " (in 'PBK_AD', line 79, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 79, column 17 to column 23)",
                                                      " (in 'PBK_AD', line 117, column 8 to column 18)",
                                                      " (in 'PBK_AD', line 117, column 20 to column 26)",
                                                      " (in 'PBK_AD', line 118, column 8 to column 18)",
                                                      " (in 'PBK_AD', line 118, column 20 to column 25)",
                                                      " (in 'PBK_AD', line 118, column 27 to column 33)",
                                                      " (in 'PBK_AD', line 4, column 2 to column 13)",
                                                      " (in 'PBK_AD', line 12, column 6 to column 15)",
                                                      " (in 'PBK_AD', line 11, column 24 to line 13, column 5)",
                                                      " (in 'PBK_AD', line 11, column 4 to line 13, column 5)",
                                                      " (in 'PBK_AD', line 14, column 4 to column 14)",
                                                      " (in 'PBK_AD', line 10, column 9 to line 15, column 3)",
                                                      " (in 'PBK_AD', line 9, column 4 to column 14)",
                                                      " (in 'PBK_AD', line 8, column 39 to line 10, column 3)",
                                                      " (in 'PBK_AD', line 8, column 9 to line 15, column 3)",
                                                      " (in 'PBK_AD', line 6, column 4 to column 30)",
                                                      " (in 'PBK_AD', line 7, column 4 to column 14)",
                                                      " (in 'PBK_AD', line 5, column 18 to line 8, column 3)",
                                                      " (in 'PBK_AD', line 5, column 2 to line 15, column 3)",
                                                      " (in 'PBK_AD', line 3, column 33 to line 16, column 1)",
                                                      " (in 'PBK_AD', line 23, column 4 to column 16)",
                                                      " (in 'PBK_AD', line 22, column 8 to line 24, column 3)",
                                                      " (in 'PBK_AD', line 20, column 4 to column 33)",
                                                      " (in 'PBK_AD', line 21, column 4 to column 90)",
                                                      " (in 'PBK_AD', line 19, column 36 to line 22, column 3)",
                                                      " (in 'PBK_AD', line 19, column 2 to line 24, column 3)",
                                                      " (in 'PBK_AD', line 18, column 48 to line 25, column 1)",
                                                      " (in 'PBK_AD', line 28, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 28, column 16 to column 22)",
                                                      " (in 'PBK_AD', line 28, column 2 to column 44)",
                                                      " (in 'PBK_AD', line 29, column 9 to column 15)",
                                                      " (in 'PBK_AD', line 29, column 16 to column 22)",
                                                      " (in 'PBK_AD', line 29, column 2 to column 31)",
                                                      " (in 'PBK_AD', line 34, column 6 to column 105)",
                                                      " (in 'PBK_AD', line 33, column 11 to line 35, column 5)",
                                                      " (in 'PBK_AD', line 32, column 6 to column 74)",
                                                      " (in 'PBK_AD', line 31, column 22 to line 33, column 5)",
                                                      " (in 'PBK_AD', line 31, column 4 to line 35, column 5)",
                                                      " (in 'PBK_AD', line 30, column 20 to line 36, column 3)",
                                                      " (in 'PBK_AD', line 30, column 2 to line 36, column 3)",
                                                      " (in 'PBK_AD', line 37, column 2 to column 20)",
                                                      " (in 'PBK_AD', line 27, column 107 to line 38, column 1)",
                                                      " (in 'PBK_AD', line 42, column 9 to column 12)",
                                                      " (in 'PBK_AD', line 42, column 14 to column 17)",
                                                      " (in 'PBK_AD', line 42, column 2 to column 55)",
                                                      " (in 'PBK_AD', line 43, column 9 to column 12)",
                                                      " (in 'PBK_AD', line 43, column 2 to column 53)",
                                                      " (in 'PBK_AD', line 44, column 9 to column 12)",
                                                      " (in 'PBK_AD', line 44, column 14 to column 17)",
                                                      " (in 'PBK_AD', line 44, column 2 to column 55)",
                                                      " (in 'PBK_AD', line 46, column 2 to column 24)",
                                                      " (in 'PBK_AD', line 40, column 45 to line 47, column 1)",
                                                      " (in 'PBK_AD', line 50, column 9 to column 10)",
                                                      " (in 'PBK_AD', line 50, column 11 to column 12)",
                                                      " (in 'PBK_AD', line 50, column 2 to column 52)",
                                                      " (in 'PBK_AD', line 51, column 2 to column 12)",
                                                      " (in 'PBK_AD', line 49, column 22 to line 52, column 1)"};
template <typename T0__, typename T1__>
int
findfirst(const T0__& t, const T1__& xt_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>>;
  const auto& xt = to_ref(xt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int i;
    i = std::numeric_limits<int>::min();
    
    current_statement__ = 87;
    i = 0;
    current_statement__ = 99;
    if (logical_eq(t, max(xt))) {
      current_statement__ = 96;
      i = (num_elements(xt) - 1);
      current_statement__ = 97;
      return i;
    } else {
      current_statement__ = 95;
      if ((primitive_value(logical_lt(t, min(xt))) || primitive_value(
          logical_gt(t, max(xt))))) {
        current_statement__ = 93;
        return i;
      } else {
        current_statement__ = 90;
        while (logical_gte(t, xt[((i + 1) - 1)])) {
          current_statement__ = 88;
          i = (i + 1);
        }
        current_statement__ = 91;
        return i;
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct findfirst_functor__ {
template <typename T0__, typename T1__>
int
operator()(const T0__& t, const T1__& xt, std::ostream* pstream__)  const 
{
return findfirst(t, xt, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
interpolate(const T0__& x, const T1__& xpt_arg__, const T2__& ypt_arg__,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>>;
  const auto& xpt = to_ref(xpt_arg__);
  const auto& ypt = to_ref(ypt_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 106;
    if ((primitive_value(logical_gte(x, min(xpt))) && primitive_value(
        logical_lte(x, max(xpt))))) {
      int idx;
      idx = std::numeric_limits<int>::min();
      
      current_statement__ = 103;
      idx = findfirst(x, xpt, pstream__);
      current_statement__ = 104;
      return (ypt[(idx - 1)] +
               (((x - xpt[(idx - 1)]) *
                  (ypt[((idx + 1) - 1)] - ypt[(idx - 1)])) /
                 (xpt[((idx + 1) - 1)] - xpt[(idx - 1)])));
    } else {
      current_statement__ = 101;
      return 0.0;
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct interpolate_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, stan::value_type_t<T1__>,
stan::value_type_t<T2__>>
operator()(const T0__& x, const T1__& xpt, const T2__& ypt,
           std::ostream* pstream__)  const 
{
return interpolate(x, xpt, ypt, pstream__);
}
};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<T7__>>, -1, -1>
exact_AD_long(const T0__& time_arg__, const int& N_time, const T2__& tacc,
              const T3__& E_arg__, const T4__& I_arg__, const T5__& U_arg__,
              const int& N_comp, const T7__& Cx, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T2__,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>,
          stan::value_type_t<T5__>, stan::promote_args_t<T7__>>;
  const auto& time = to_ref(time_arg__);
  const auto& E = to_ref(E_arg__);
  const auto& I = to_ref(I_arg__);
  const auto& U = to_ref(U_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 108;
    validate_non_negative_index("E_inv", "N_comp", N_comp);
    current_statement__ = 109;
    validate_non_negative_index("E_inv", "N_comp", N_comp);
    Eigen::Matrix<local_scalar_t__, -1, -1> E_inv;
    E_inv = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_comp);
    stan::math::fill(E_inv, DUMMY_VAR__);
    
    current_statement__ = 110;
    assign(E_inv, nil_index_list(), inverse(E), "assigning variable E_inv");
    current_statement__ = 111;
    validate_non_negative_index("E_out", "N_comp", N_comp);
    current_statement__ = 112;
    validate_non_negative_index("E_out", "N_time", N_time);
    Eigen::Matrix<local_scalar_t__, -1, -1> E_out;
    E_out = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_time);
    stan::math::fill(E_out, DUMMY_VAR__);
    
    current_statement__ = 120;
    for (int i = 1; i <= N_time; ++i) {
      current_statement__ = 118;
      if (logical_lt(time[(i - 1)], tacc)) {
        current_statement__ = 116;
        assign(E_out,
          cons_list(index_min_max(1, N_comp),
            cons_list(index_uni(i), nil_index_list())),
          multiply(
            multiply(
              multiply(E_inv,
                subtract(matrix_exp(multiply(time[(i - 1)], E)), I)), U), Cx),
          "assigning variable E_out");
      } else {
        current_statement__ = 114;
        assign(E_out,
          cons_list(index_min_max(1, N_comp),
            cons_list(index_uni(i), nil_index_list())),
          multiply(
            multiply(
              multiply(E_inv,
                subtract(matrix_exp(multiply(time[(i - 1)], E)),
                  matrix_exp(multiply((time[(i - 1)] - tacc), E)))), U), Cx),
          "assigning variable E_out");
      }}
    current_statement__ = 121;
    return transpose(E_out);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct exact_AD_long_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<T7__>>, -1, -1>
operator()(const T0__& time, const int& N_time, const T2__& tacc,
           const T3__& E, const T4__& I, const T5__& U, const int& N_comp,
           const T7__& Cx, std::ostream* pstream__)  const 
{
return exact_AD_long(time, N_time, tacc, E, I, U, N_comp, Cx, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, -1>
matrix_E(const T0__& ke_arg__, const T1__& k_arg__, const int& N_k,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& ke = to_ref(ke_arg__);
  const auto& k = to_ref(k_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 123;
    validate_non_negative_index("m", "N_k", N_k);
    current_statement__ = 124;
    validate_non_negative_index("m", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, -1> m;
    m = Eigen::Matrix<local_scalar_t__, -1, -1>(N_k, N_k);
    stan::math::fill(m, DUMMY_VAR__);
    
    current_statement__ = 125;
    assign(m, nil_index_list(), add_diag(k, rep_vector(0, N_k)),
      "assigning variable m");
    current_statement__ = 126;
    validate_non_negative_index("diag_k", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, 1> diag_k;
    diag_k = Eigen::Matrix<local_scalar_t__, -1, 1>(N_k);
    stan::math::fill(diag_k, DUMMY_VAR__);
    
    current_statement__ = 127;
    assign(diag_k, nil_index_list(),
      subtract(minus(ke), multiply(m, rep_vector(1, N_k))),
      "assigning variable diag_k");
    current_statement__ = 128;
    validate_non_negative_index("matrix_E_rtn", "N_k", N_k);
    current_statement__ = 129;
    validate_non_negative_index("matrix_E_rtn", "N_k", N_k);
    Eigen::Matrix<local_scalar_t__, -1, -1> matrix_E_rtn;
    matrix_E_rtn = Eigen::Matrix<local_scalar_t__, -1, -1>(N_k, N_k);
    stan::math::fill(matrix_E_rtn, DUMMY_VAR__);
    
    current_statement__ = 130;
    assign(matrix_E_rtn, nil_index_list(), add_diag(k, diag_k),
      "assigning variable matrix_E_rtn");
    current_statement__ = 131;
    return matrix_E_rtn;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct matrix_E_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, -1>
operator()(const T0__& ke, const T1__& k, const int& N_k,
           std::ostream* pstream__)  const 
{
return matrix_E(ke, k, N_k, pstream__);
}
};
Eigen::Matrix<double, -1, -1>
matrix_I(const int& k, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 133;
    validate_non_negative_index("I", "k", k);
    current_statement__ = 134;
    validate_non_negative_index("I", "k", k);
    Eigen::Matrix<local_scalar_t__, -1, -1> I;
    I = Eigen::Matrix<local_scalar_t__, -1, -1>(k, k);
    stan::math::fill(I, DUMMY_VAR__);
    
    current_statement__ = 135;
    assign(I, nil_index_list(), add_diag(rep_matrix(0, k, k), 1),
      "assigning variable I");
    current_statement__ = 136;
    return I;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct matrix_I_functor__ {
Eigen::Matrix<double, -1, -1>
operator()(const int& k, std::ostream* pstream__)  const 
{
return matrix_I(k, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_PBK_AD final : public model_base_crtp<model_PBK_AD> {
private:
  int N_obs_comp;
  int N_rep;
  int N_comp;
  Eigen::Matrix<double, -1, 1> time_obs_comp;
  Eigen::Matrix<double, -1, 1> ke_nest;
  Eigen::Matrix<double, -1, 1> ku_nest;
  Eigen::Matrix<double, -1, -1> k_nest;
  std::vector<std::vector<std::vector<double>>> val_obs_comp;
  double t0;
  double tacc;
  double val_obs_exp;
 
public:
  ~model_PBK_AD() { }
  
  inline std::string model_name() const final { return "model_PBK_AD"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_PBK_AD(stan::io::var_context& context__,
               unsigned int random_seed__ = 0,
               std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_PBK_AD_namespace::model_PBK_AD";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 48;
      context__.validate_dims("data initialization","N_obs_comp","int",
          context__.to_vec());
      N_obs_comp = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      N_obs_comp = context__.vals_i("N_obs_comp")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "N_obs_comp", N_obs_comp, 0);
      current_statement__ = 49;
      context__.validate_dims("data initialization","N_rep","int",
          context__.to_vec());
      N_rep = std::numeric_limits<int>::min();
      
      current_statement__ = 49;
      N_rep = context__.vals_i("N_rep")[(1 - 1)];
      current_statement__ = 49;
      current_statement__ = 49;
      check_greater_or_equal(function__, "N_rep", N_rep, 0);
      current_statement__ = 50;
      context__.validate_dims("data initialization","N_comp","int",
          context__.to_vec());
      N_comp = std::numeric_limits<int>::min();
      
      current_statement__ = 50;
      N_comp = context__.vals_i("N_comp")[(1 - 1)];
      current_statement__ = 50;
      current_statement__ = 50;
      check_greater_or_equal(function__, "N_comp", N_comp, 0);
      current_statement__ = 51;
      validate_non_negative_index("time_obs_comp", "N_obs_comp", N_obs_comp);
      current_statement__ = 52;
      context__.validate_dims("data initialization","time_obs_comp","double",
          context__.to_vec(N_obs_comp));
      time_obs_comp = Eigen::Matrix<double, -1, 1>(N_obs_comp);
      stan::math::fill(time_obs_comp, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> time_obs_comp_flat__;
        current_statement__ = 52;
        assign(time_obs_comp_flat__, nil_index_list(),
          context__.vals_r("time_obs_comp"),
          "assigning variable time_obs_comp_flat__");
        current_statement__ = 52;
        pos__ = 1;
        current_statement__ = 52;
        for (int sym1__ = 1; sym1__ <= N_obs_comp; ++sym1__) {
          current_statement__ = 52;
          assign(time_obs_comp,
            cons_list(index_uni(sym1__), nil_index_list()),
            time_obs_comp_flat__[(pos__ - 1)],
            "assigning variable time_obs_comp");
          current_statement__ = 52;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 53;
      validate_non_negative_index("ke_nest", "N_comp", N_comp);
      current_statement__ = 54;
      context__.validate_dims("data initialization","ke_nest","double",
          context__.to_vec(N_comp));
      ke_nest = Eigen::Matrix<double, -1, 1>(N_comp);
      stan::math::fill(ke_nest, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> ke_nest_flat__;
        current_statement__ = 54;
        assign(ke_nest_flat__, nil_index_list(), context__.vals_r("ke_nest"),
          "assigning variable ke_nest_flat__");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          current_statement__ = 54;
          assign(ke_nest, cons_list(index_uni(sym1__), nil_index_list()),
            ke_nest_flat__[(pos__ - 1)], "assigning variable ke_nest");
          current_statement__ = 54;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 55;
      validate_non_negative_index("ku_nest", "N_comp", N_comp);
      current_statement__ = 56;
      context__.validate_dims("data initialization","ku_nest","double",
          context__.to_vec(N_comp));
      ku_nest = Eigen::Matrix<double, -1, 1>(N_comp);
      stan::math::fill(ku_nest, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> ku_nest_flat__;
        current_statement__ = 56;
        assign(ku_nest_flat__, nil_index_list(), context__.vals_r("ku_nest"),
          "assigning variable ku_nest_flat__");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          current_statement__ = 56;
          assign(ku_nest, cons_list(index_uni(sym1__), nil_index_list()),
            ku_nest_flat__[(pos__ - 1)], "assigning variable ku_nest");
          current_statement__ = 56;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 57;
      validate_non_negative_index("k_nest", "N_comp", N_comp);
      current_statement__ = 58;
      validate_non_negative_index("k_nest", "N_comp", N_comp);
      current_statement__ = 59;
      context__.validate_dims("data initialization","k_nest","double",
          context__.to_vec(N_comp, N_comp));
      k_nest = Eigen::Matrix<double, -1, -1>(N_comp, N_comp);
      stan::math::fill(k_nest, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> k_nest_flat__;
        current_statement__ = 59;
        assign(k_nest_flat__, nil_index_list(), context__.vals_r("k_nest"),
          "assigning variable k_nest_flat__");
        current_statement__ = 59;
        pos__ = 1;
        current_statement__ = 59;
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          current_statement__ = 59;
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            current_statement__ = 59;
            assign(k_nest,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              k_nest_flat__[(pos__ - 1)], "assigning variable k_nest");
            current_statement__ = 59;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 60;
      validate_non_negative_index("val_obs_comp", "N_obs_comp", N_obs_comp);
      current_statement__ = 61;
      validate_non_negative_index("val_obs_comp", "N_rep", N_rep);
      current_statement__ = 62;
      validate_non_negative_index("val_obs_comp", "N_comp", N_comp);
      current_statement__ = 63;
      context__.validate_dims("data initialization","val_obs_comp","double",
          context__.to_vec(N_obs_comp, N_rep, N_comp));
      val_obs_comp = std::vector<std::vector<std::vector<double>>>(N_obs_comp, std::vector<std::vector<double>>(N_rep, std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> val_obs_comp_flat__;
        current_statement__ = 63;
        assign(val_obs_comp_flat__, nil_index_list(),
          context__.vals_r("val_obs_comp"),
          "assigning variable val_obs_comp_flat__");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          current_statement__ = 63;
          for (int sym2__ = 1; sym2__ <= N_rep; ++sym2__) {
            current_statement__ = 63;
            for (int sym3__ = 1; sym3__ <= N_obs_comp; ++sym3__) {
              current_statement__ = 63;
              assign(val_obs_comp,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                val_obs_comp_flat__[(pos__ - 1)],
                "assigning variable val_obs_comp");
              current_statement__ = 63;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 64;
      context__.validate_dims("data initialization","t0","double",
          context__.to_vec());
      t0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 64;
      t0 = context__.vals_r("t0")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization","tacc","double",
          context__.to_vec());
      tacc = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      tacc = context__.vals_r("tacc")[(1 - 1)];
      current_statement__ = 66;
      context__.validate_dims("data initialization","val_obs_exp","double",
          context__.to_vec());
      val_obs_exp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      val_obs_exp = context__.vals_r("val_obs_exp")[(1 - 1)];
      current_statement__ = 67;
      validate_non_negative_index("log10ku", "N_comp", N_comp);
      current_statement__ = 68;
      validate_non_negative_index("log10ke", "N_comp", N_comp);
      current_statement__ = 69;
      validate_non_negative_index("log10k", "N_comp", N_comp);
      current_statement__ = 70;
      validate_non_negative_index("log10k", "N_comp", N_comp);
      current_statement__ = 71;
      validate_non_negative_index("sigma", "N_comp", N_comp);
      current_statement__ = 72;
      validate_non_negative_index("Cpred_comp", "N_obs_comp", N_obs_comp);
      current_statement__ = 73;
      validate_non_negative_index("Cpred_comp", "N_comp", N_comp);
      current_statement__ = 74;
      validate_non_negative_index("ku", "N_comp", N_comp);
      current_statement__ = 75;
      validate_non_negative_index("ke", "N_comp", N_comp);
      current_statement__ = 76;
      validate_non_negative_index("k", "N_comp", N_comp);
      current_statement__ = 77;
      validate_non_negative_index("k", "N_comp", N_comp);
      current_statement__ = 78;
      validate_non_negative_index("E", "N_comp", N_comp);
      current_statement__ = 79;
      validate_non_negative_index("E", "N_comp", N_comp);
      current_statement__ = 80;
      validate_non_negative_index("I", "N_comp", N_comp);
      current_statement__ = 81;
      validate_non_negative_index("I", "N_comp", N_comp);
      current_statement__ = 82;
      validate_non_negative_index("val_pred_comp", "N_obs_comp", N_obs_comp);
      current_statement__ = 83;
      validate_non_negative_index("val_pred_comp", "N_comp", N_comp);
      current_statement__ = 84;
      validate_non_negative_index("log_lik", "N_obs_comp", N_obs_comp);
      current_statement__ = 85;
      validate_non_negative_index("log_lik", "N_rep", N_rep);
      current_statement__ = 86;
      validate_non_negative_index("log_lik", "N_comp", N_comp);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += N_comp;
      num_params_r__ += N_comp;
      num_params_r__ += N_comp * N_comp;
      num_params_r__ += N_comp;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_PBK_AD_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> log10ku;
      log10ku = std::vector<local_scalar_t__>(N_comp, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 1;
        assign(log10ku, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable log10ku");}
      std::vector<local_scalar_t__> log10ke;
      log10ke = std::vector<local_scalar_t__>(N_comp, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 2;
        assign(log10ke, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable log10ke");}
      std::vector<std::vector<local_scalar_t__>> log10k;
      log10k = std::vector<std::vector<local_scalar_t__>>(N_comp, std::vector<local_scalar_t__>(N_comp, DUMMY_VAR__));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          current_statement__ = 3;
          assign(log10k,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable log10k");}}
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(N_comp, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> Cpred_comp;
      Cpred_comp = Eigen::Matrix<local_scalar_t__, -1, -1>(N_obs_comp, N_comp);
      stan::math::fill(Cpred_comp, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> ku;
      ku = Eigen::Matrix<local_scalar_t__, -1, 1>(N_comp);
      stan::math::fill(ku, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> ke;
      ke = Eigen::Matrix<local_scalar_t__, -1, 1>(N_comp);
      stan::math::fill(ke, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> k;
      k = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_comp);
      stan::math::fill(k, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> E;
      E = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_comp);
      stan::math::fill(E, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> I;
      I = Eigen::Matrix<local_scalar_t__, -1, -1>(N_comp, N_comp);
      stan::math::fill(I, DUMMY_VAR__);
      
      current_statement__ = 17;
      for (int i = 1; i <= N_comp; ++i) {
        current_statement__ = 11;
        assign(ku, cons_list(index_uni(i), nil_index_list()),
          (logical_eq(ku_nest[(i - 1)], 0) ?
             stan::math::promote_scalar<local_scalar_t__>(0) :
             stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                            log10ku[(i - 1)]))),
          "assigning variable ku");
        current_statement__ = 12;
        assign(ke, cons_list(index_uni(i), nil_index_list()),
          (logical_eq(ke_nest[(i - 1)], 0) ?
             stan::math::promote_scalar<local_scalar_t__>(0) :
             stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                            log10ke[(i - 1)]))),
          "assigning variable ke");
        current_statement__ = 15;
        for (int j = 1; j <= N_comp; ++j) {
          current_statement__ = 13;
          assign(k,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            (
               logical_eq(
                 rvalue(k_nest,
                   cons_list(index_uni(i),
                     cons_list(index_uni(j), nil_index_list())), "k_nest"),
                 0) ? stan::math::promote_scalar<local_scalar_t__>(0) :
               stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                              log10k[
                                                              (i - 1)][
                                                              (j - 1)]))),
            "assigning variable k");}}
      current_statement__ = 18;
      assign(E, nil_index_list(), matrix_E(ke, k, N_comp, pstream__),
        "assigning variable E");
      current_statement__ = 19;
      assign(I, nil_index_list(), matrix_I(N_comp, pstream__),
        "assigning variable I");
      current_statement__ = 20;
      assign(Cpred_comp, nil_index_list(),
        exact_AD_long(time_obs_comp, N_obs_comp, tacc, E, I, ku, N_comp,
          val_obs_exp, pstream__), "assigning variable Cpred_comp");
      {
        current_statement__ = 35;
        lp_accum__.add(uniform_lpdf<false>(log10ku, -5, 5));
        current_statement__ = 36;
        lp_accum__.add(uniform_lpdf<false>(log10ke, -5, 5));
        current_statement__ = 39;
        for (int i_comp = 1; i_comp <= N_comp; ++i_comp) {
          current_statement__ = 37;
          lp_accum__.add(
            uniform_lpdf<false>(
              rvalue(log10k,
                cons_list(index_min_max(1, N_comp),
                  cons_list(index_uni(i_comp), nil_index_list())), "log10k"),
              -5, 5));}
        current_statement__ = 40;
        lp_accum__.add(gamma_lpdf<false>(sigma, 0.01, 0.01));
        current_statement__ = 47;
        for (int i_rep = 1; i_rep <= N_rep; ++i_rep) {
          current_statement__ = 45;
          for (int i = 1; i <= N_obs_comp; ++i) {
            current_statement__ = 43;
            for (int i_comp = 1; i_comp <= N_comp; ++i_comp) {
              current_statement__ = 41;
              lp_accum__.add(
                normal_lpdf<false>(
                  val_obs_comp[(i - 1)][(i_rep - 1)][(i_comp - 1)],
                  rvalue(Cpred_comp,
                    cons_list(index_uni(i),
                      cons_list(index_uni(i_comp), nil_index_list())),
                    "Cpred_comp"), sigma[(i_comp - 1)]));}}}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_PBK_AD_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> log10ku;
      log10ku = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 1;
        assign(log10ku, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable log10ku");}
      std::vector<double> log10ke;
      log10ke = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 2;
        assign(log10ke, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable log10ke");}
      std::vector<std::vector<double>> log10k;
      log10k = std::vector<std::vector<double>>(N_comp, std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          current_statement__ = 3;
          assign(log10k,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable log10k");}}
      std::vector<double> sigma;
      sigma = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      Eigen::Matrix<double, -1, -1> Cpred_comp;
      Cpred_comp = Eigen::Matrix<double, -1, -1>(N_obs_comp, N_comp);
      stan::math::fill(Cpred_comp, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ku;
      ku = Eigen::Matrix<double, -1, 1>(N_comp);
      stan::math::fill(ku, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ke;
      ke = Eigen::Matrix<double, -1, 1>(N_comp);
      stan::math::fill(ke, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> k;
      k = Eigen::Matrix<double, -1, -1>(N_comp, N_comp);
      stan::math::fill(k, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> E;
      E = Eigen::Matrix<double, -1, -1>(N_comp, N_comp);
      stan::math::fill(E, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> I;
      I = Eigen::Matrix<double, -1, -1>(N_comp, N_comp);
      stan::math::fill(I, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(log10ku[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(log10ke[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          vars__.emplace_back(log10k[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 17;
      for (int i = 1; i <= N_comp; ++i) {
        current_statement__ = 11;
        assign(ku, cons_list(index_uni(i), nil_index_list()),
          (logical_eq(ku_nest[(i - 1)], 0) ?
             stan::math::promote_scalar<local_scalar_t__>(0) :
             stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                            log10ku[(i - 1)]))),
          "assigning variable ku");
        current_statement__ = 12;
        assign(ke, cons_list(index_uni(i), nil_index_list()),
          (logical_eq(ke_nest[(i - 1)], 0) ?
             stan::math::promote_scalar<local_scalar_t__>(0) :
             stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                            log10ke[(i - 1)]))),
          "assigning variable ke");
        current_statement__ = 15;
        for (int j = 1; j <= N_comp; ++j) {
          current_statement__ = 13;
          assign(k,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            (
               logical_eq(
                 rvalue(k_nest,
                   cons_list(index_uni(i),
                     cons_list(index_uni(j), nil_index_list())), "k_nest"),
                 0) ? stan::math::promote_scalar<local_scalar_t__>(0) :
               stan::math::promote_scalar<local_scalar_t__>(pow(10,
                                                              log10k[
                                                              (i - 1)][
                                                              (j - 1)]))),
            "assigning variable k");}}
      current_statement__ = 18;
      assign(E, nil_index_list(), matrix_E(ke, k, N_comp, pstream__),
        "assigning variable E");
      current_statement__ = 19;
      assign(I, nil_index_list(), matrix_I(N_comp, pstream__),
        "assigning variable I");
      current_statement__ = 20;
      assign(Cpred_comp, nil_index_list(),
        exact_AD_long(time_obs_comp, N_obs_comp, tacc, E, I, ku, N_comp,
          val_obs_exp, pstream__), "assigning variable Cpred_comp");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
            vars__.emplace_back(
              rvalue(Cpred_comp,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "Cpred_comp"));}}
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          vars__.emplace_back(ku[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          vars__.emplace_back(ke[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            vars__.emplace_back(
              rvalue(k,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "k"));}}
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            vars__.emplace_back(
              rvalue(E,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "E"));}}
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            vars__.emplace_back(
              rvalue(I,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "I"));}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<std::vector<double>> val_pred_comp;
      val_pred_comp = std::vector<std::vector<double>>(N_obs_comp, std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN()));
      
      std::vector<std::vector<std::vector<double>>> log_lik;
      log_lik = std::vector<std::vector<std::vector<double>>>(N_obs_comp, std::vector<std::vector<double>>(N_rep, std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN())));
      
      current_statement__ = 27;
      for (int i_comp = 1; i_comp <= N_comp; ++i_comp) {
        current_statement__ = 25;
        for (int t = 1; t <= N_obs_comp; ++t) {
          current_statement__ = 23;
          assign(val_pred_comp,
            cons_list(index_uni(t),
              cons_list(index_uni(i_comp), nil_index_list())),
            normal_rng(
              rvalue(Cpred_comp,
                cons_list(index_uni(t),
                  cons_list(index_uni(i_comp), nil_index_list())),
                "Cpred_comp"), sigma[(i_comp - 1)], base_rng__),
            "assigning variable val_pred_comp");}}
      current_statement__ = 34;
      for (int i_rep = 1; i_rep <= N_rep; ++i_rep) {
        current_statement__ = 32;
        for (int i = 1; i <= N_obs_comp; ++i) {
          current_statement__ = 30;
          for (int i_comp = 1; i_comp <= N_comp; ++i_comp) {
            current_statement__ = 28;
            assign(log_lik,
              cons_list(index_uni(i),
                cons_list(index_uni(i_rep),
                  cons_list(index_uni(i_comp), nil_index_list()))),
              normal_lpdf<false>(
                val_obs_comp[(i - 1)][(i_rep - 1)][(i_comp - 1)],
                rvalue(Cpred_comp,
                  cons_list(index_uni(i),
                    cons_list(index_uni(i_comp), nil_index_list())),
                  "Cpred_comp"), sigma[(i_comp - 1)]),
              "assigning variable log_lik");}}}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
          vars__.emplace_back(val_pred_comp[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_rep; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= N_obs_comp; ++sym3__) {
            vars__.emplace_back(
              log_lik[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> log10ku;
      log10ku = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(log10ku, nil_index_list(), context__.vals_r("log10ku"),
        "assigning variable log10ku");
      std::vector<double> log10ke;
      log10ke = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(log10ke, nil_index_list(), context__.vals_r("log10ke"),
        "assigning variable log10ke");
      std::vector<std::vector<double>> log10k;
      log10k = std::vector<std::vector<double>>(N_comp, std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> log10k_flat__;
        current_statement__ = 3;
        assign(log10k_flat__, nil_index_list(), context__.vals_r("log10k"),
          "assigning variable log10k_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            current_statement__ = 3;
            assign(log10k,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              log10k_flat__[(pos__ - 1)], "assigning variable log10k");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      std::vector<double> sigma;
      sigma = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      std::vector<double> sigma_free__;
      sigma_free__ = std::vector<double>(N_comp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(log10ku[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(log10ke[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          vars__.emplace_back(log10k[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("log10ku");
    names__.emplace_back("log10ke");
    names__.emplace_back("log10k");
    names__.emplace_back("sigma");
    names__.emplace_back("Cpred_comp");
    names__.emplace_back("ku");
    names__.emplace_back("ke");
    names__.emplace_back("k");
    names__.emplace_back("E");
    names__.emplace_back("I");
    names__.emplace_back("val_pred_comp");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_obs_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_obs_comp),
                                             static_cast<size_t>(N_comp)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_obs_comp),
                                             static_cast<size_t>(N_rep),
                                             static_cast<size_t>(N_comp)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ku" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ke" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log10k" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cpred_comp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ku" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ke" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "E" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "I" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "val_pred_comp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_rep; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= N_obs_comp; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ku" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log10ke" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log10k" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cpred_comp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ku" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ke" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "E" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "I" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_obs_comp; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "val_pred_comp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_comp; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_rep; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= N_obs_comp; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log10ku\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log10ke\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log10k\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"Cpred_comp\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_obs_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ku\",\"type\":{\"name\":\"vector\",\"length\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ke\",\"type\":{\"name\":\"vector\",\"length\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"E\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"I\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"val_pred_comp\",\"type\":{\"name\":\"array\",\"length\":" << N_obs_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N_obs_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_rep << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log10ku\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log10ke\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"log10k\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"Cpred_comp\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_obs_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ku\",\"type\":{\"name\":\"vector\",\"length\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"ke\",\"type\":{\"name\":\"vector\",\"length\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"E\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"I\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_comp << ",\"cols\":" << N_comp << "},\"block\":\"transformed_parameters\"},{\"name\":\"val_pred_comp\",\"type\":{\"name\":\"array\",\"length\":" << N_obs_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N_obs_comp << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_rep << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_comp << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_PBK_AD_namespace::model_PBK_AD;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_PBK_AD_namespace::profiles__;
}
#endif
#endif
