% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{labels_SPSS}
\alias{labels_SPSS}
\alias{numberSPSS}
\alias{substrSPSS}
\title{Format axis tick labels similar to SPSS}
\usage{
numberSPSS(x, big.mark = "", ...)

substrSPSS(x, start = 1, stop = 8)
}
\arguments{
\item{x}{for \code{numberSPSS}, a numeric vector to format.  For
\code{substrSPSS}, a vector of character strings to be cut.}

\item{big.mark}{a character string to be inserted every 3 digits to
separate thousands.  The default is an empty string for no separation.}

\item{\dots}{additional arguments to be passed to
\code{\link[scales]{number}}.}

\item{start, stop}{integers giving the first and last character to remain in
the cut string, respectively.  The default is to cut strings to the first 8
characters.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Format axis tick labels in a similar manner to SPSS to mimic the look of
SPSS graphs.
}
\details{
\code{numberSPSS} is a wrapper for \code{\link[scales]{number}} that by
default does not put a separator every 3 digits so separate thousands.  It
mainly exists to prevent scientific notation in axis tick labels, hence it
is typically supplied as the \code{labels} argument of
\code{\link[ggplot2]{scale_x_continuous}} or
\code{\link[ggplot2]{scale_y_continuous}}.

\code{substrSPSS} is a wrapper for \code{\link{substr}} to cut character
strings by default to the first 8 characters, which is SPSS behavior for
the tick labels of a discrete axis in some (but not all) plots.  It is
typically supplied as the  \code{labels} argument of
\code{\link[ggplot2]{scale_x_discrete}} or
\code{\link[ggplot2]{scale_y_discrete}}.
}
\keyword{utilities}
