% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsore.R
\name{zscore}
\alias{zscore}
\alias{zscoreGrowthCurve}
\title{Calculates Z-Scores of a distribution}
\usage{
zscore(.data, round, na.rm = TRUE)

zscoreGrowthCurve(Xi, Mi, Si, Li = !0)
}
\arguments{
\item{.data}{data object}

\item{round}{round output to how many decimal place description}

\item{na.rm}{remove NA values before calculating z-scores}

\item{Xi}{physical measurement (e.g. weight, length, head circumference, stature or calculated BMI value)}

\item{Mi}{values from the table (see reference) corresponding to the age in months of the child}

\item{Si}{values from the table (see reference) corresponding to the age in months of the child}

\item{Li}{values from the table (see reference) corresponding to the age in months of the child}
}
\value{
zscore calculated based on data object or parameters
}
\description{
Calculates Z-Scores based on data
}
\examples{
# Capture z-score from the following distribution x
x = c(6, 7, 7, 12, 13, 13, 15, 16, 19, 22)
z_scores = zscore(x, round = 2) # limit to 2 decimal place
z_scores = zscore(x) # no decimal place limit

df = data.frame(val = x, zscore = z_scores)
head(df)
#EXAMPLE for zscore based on CDC growth chart

# Calculate the zscore for a patient weighing 50kg
Li=-0.1600954
Mi=9.476500305
Si=0.11218624
Xi=50
zscoreGrowthCurve(Xi,Mi,Si,Li)

}
\references{
CDC growth chart Z score calculation: https://www.cdc.gov/growthcharts/cdc-data-files.htm
}
